/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ExprEvaluator;

final class ExprParserContext {
    ExprEvaluator exprEvaluator;
    boolean negate;
    boolean logicalNot;
    boolean bracketMode;
    boolean bracketEndFlag;
    boolean questionMode;
    boolean questionEndFlag;
    static final int MASK = 511;
    static final EntryNode<String>[] VAR_INDEXED = new EntryNode[512];
    static int count;
    static boolean disabledIndexed;

    ExprParserContext() {
    }

    ExprParserContext(ExprEvaluator evaluator, boolean negate, boolean logicalNot) {
        this.setContext(evaluator, negate, logicalNot);
    }

    void setContext(ExprEvaluator evaluator, boolean negate, boolean logicalNot) {
        this.exprEvaluator = evaluator;
        this.negate = negate;
        this.logicalNot = logicalNot;
    }

    static String getString(char[] buf, int offset, int len) {
        if (len > 8 || disabledIndexed) {
            return new String(buf, offset, len);
        }
        long key = 0L;
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            char ch = buf[i];
            if (ch > '\u00ff') {
                return new String(buf, offset, len);
            }
            key = key << 8 | (long)ch;
        }
        return ExprParserContext.getKey(buf, offset, len, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getKey(char[] buf, int offset, int len, long hash) {
        String value = ExprParserContext.getIndexedKey(hash);
        if (value != null) {
            return value;
        }
        EntryNode<String>[] entryNodeArray = VAR_INDEXED;
        synchronized (VAR_INDEXED) {
            value = ExprParserContext.getIndexedKey(hash);
            if (value != null) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return value;
            }
            value = new String(buf, offset, len);
            ExprParserContext.setIndexedKey(hash, value);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return value;
        }
    }

    static void setIndexedKey(long hash, String value) {
        int index = (int)(hash & 0x1FFL);
        EntryNode<String> newNode = new EntryNode<String>(hash, value);
        EntryNode<String> entryNode = VAR_INDEXED[index];
        newNode.next = entryNode;
        ExprParserContext.VAR_INDEXED[index] = newNode;
        disabledIndexed = ++count > 511;
    }

    static String getIndexedKey(long hash) {
        int index = (int)(hash & 0x1FFL);
        EntryNode<String> entryNode = VAR_INDEXED[index];
        while (entryNode != null) {
            if (entryNode.key == hash) {
                return (String)entryNode.value;
            }
            entryNode = entryNode.next;
        }
        return null;
    }

    static class EntryNode<T> {
        long key;
        T value;
        EntryNode<T> next;

        public EntryNode(long key, T value) {
            this.key = key;
            this.value = value;
        }
    }
}

