/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile.javassist;

import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.CompilerExpression;
import io.github.wycst.wast.common.expression.compile.CompilerExpressionCoder;
import io.github.wycst.wast.common.expression.compile.ValueHolder;
import io.github.wycst.wast.common.expression.compile.javassist.JavassistCompilerExpression;
import io.github.wycst.wast.common.expression.functions.JavassistExprFunction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;

public class JavassistCompilerExpressionCoder
extends CompilerExpressionCoder {
    @Override
    protected CompilerExpression compile(Map<String, Object> vars, CompilerEnvironment environment) {
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.importPackage(ValueHolder.class.getName());
            pool.importPackage(ElVariableInvoker.class.getName());
            pool.importPackage(ExprFunction.class.getName());
            pool.importPackage(JavassistExprFunction.class.getName());
            Set<Class> importSet = environment.getImportSet();
            for (Class iptClass : importSet) {
                pool.importPackage(iptClass.getName());
            }
            CtClass ctClass = pool.makeClass(vars.get("className").toString(), pool.get(JavassistCompilerExpression.class.getName()));
            List fieldSources = (List)vars.get("fieldSources");
            if (fieldSources != null) {
                for (String fieldSource : fieldSources) {
                    CtField ctField = CtField.make((String)fieldSource, (CtClass)ctClass);
                    ctClass.addField(ctField);
                }
            }
            String constructorBody = vars.get("constructorBody").toString();
            CtConstructor ctConstructor = new CtConstructor(new CtClass[]{pool.get(CompilerEnvironment.class.getName())}, ctClass);
            ctConstructor.setBody(constructorBody);
            ctConstructor.setModifiers(1);
            ctClass.addConstructor(ctConstructor);
            List functionSources = (List)vars.get("functionSources");
            if (functionSources != null) {
                for (String functionSource : functionSources) {
                    CtMethod functionMethod = CtMethod.make((String)functionSource, (CtClass)ctClass);
                    functionMethod.setModifiers(functionMethod.getModifiers() | 0x80);
                    ctClass.addMethod(functionMethod);
                }
            }
            String invokeObjectSource = vars.get("invokeObjectSource").toString();
            CtMethod invokeObjectMethod = CtMethod.make((String)invokeObjectSource, (CtClass)ctClass);
            ctClass.addMethod(invokeObjectMethod);
            String invokeMapSource = vars.get("invokeMapSource").toString();
            CtMethod invokeMapMethod = CtMethod.make((String)invokeMapSource, (CtClass)ctClass);
            ctClass.addMethod(invokeMapMethod);
            Class cls = ctClass.toClass();
            ctClass.detach();
            return (CompilerExpression)cls.getDeclaredConstructors()[0].newInstance(environment);
        }
        catch (Exception e) {
            String message;
            if (e.getClass().getName() == "java.lang.reflect.InaccessibleObjectException" && (message = e.getMessage()) != null && message.indexOf("\"opens java.lang\"") > -1) {
                throw new ExpressionException("Coder.Javassist compile on JDK16+, please add vm options: --add-opens java.base/java.lang=ALL-UNNAMED or switch mode Coder.Native", e);
            }
            throw new ExpressionException("javassist compile fail", e);
        }
    }
}

