/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.annotation.MethodInvokePriority;
import io.github.wycst.wast.common.exceptions.InvokeReflectException;
import io.github.wycst.wast.common.reflect.FieldInfo;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.GetterMethodInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.reflect.SetterMethodInfo;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.tools.FNV;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassStrucWrap {
    private static final Map<Class<?>, ClassStrucWrap> CLASS_STRUC_WRAP_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, List> COMPATIBLE_TYPES = new HashMap();
    private static Class[] USE_GETTER_METHOD_TYPE_LIST = new Class[]{Throwable.class, Error.class};
    private static final int MAX_STRUCTURE_COUNT = 10000;
    private final Class<?> sourceClass;
    private final boolean privateFlag;
    private final boolean publicFlag;
    private final boolean assignableFromMap;
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private ClassWrapperType classWrapperType = ClassWrapperType.Normal;
    private boolean javaBuiltInModule;
    private boolean forceUseFields;
    private boolean record;
    private boolean temporal;
    private boolean subEnum;
    private int fieldCount;
    private Map<String, SetterInfo> setterInfos = new LinkedHashMap<String, SetterInfo>();
    private List<GetterInfo> getterInfos;
    private List<GetterInfo> getterInfoOfFields;
    private Map<String, GetterInfo> getterInfoMap = new HashMap<String, GetterInfo>();
    private Map<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
    private long fieldsCheckCode;
    private Object[] constructorArgs;
    private Constructor<?> defaultConstructor;
    volatile Map<String, List<Method>> publicMethods = null;
    static final Field modifierField;
    static final Method getParametersMethod;

    private ClassStrucWrap(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
        this.privateFlag = Modifier.isPrivate(sourceClass.getModifiers());
        this.publicFlag = Modifier.isPublic(sourceClass.getModifiers());
        this.assignableFromMap = Map.class.isAssignableFrom(sourceClass);
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        ClassStrucWrap.addAnnotations(annotationMap, sourceClass.getDeclaredAnnotations());
        this.annotationMap = annotationMap;
    }

    public List<GetterInfo> getGetterInfos() {
        return this.getterInfos;
    }

    public List<GetterInfo> getGetterInfos(boolean fieldAgent) {
        if (fieldAgent || this.javaBuiltInModule) {
            return this.getterInfoOfFields;
        }
        return this.getterInfos;
    }

    public GetterInfo getGetterInfo(String name) {
        return this.getterInfoMap.get(name);
    }

    public GetterInfo matchGenerateGetterInfo(String name) {
        for (GetterInfo getterInfo : this.getterInfos) {
            if (!name.equals(getterInfo.getName())) continue;
            return getterInfo;
        }
        for (GetterInfo getterInfo : this.getterInfoOfFields) {
            if (!name.equals(getterInfo.getName())) continue;
            return getterInfo;
        }
        return null;
    }

    private void fillGetterInfoMap() {
        for (GetterInfo getterInfo : this.getterInfos) {
            String name;
            FieldInfo fieldInfo;
            if (getterInfo.existField() && (fieldInfo = this.fieldInfoMap.get(name = getterInfo.getField().getName())) != null) {
                getterInfo.setGenericParameterizedType(fieldInfo.getSetterInfo().getGenericParameterizedType());
            }
            this.getterInfoMap.put(getterInfo.getName(), getterInfo);
        }
        for (GetterInfo getterInfo : this.getterInfoOfFields) {
            this.getterInfoMap.put(getterInfo.getName(), getterInfo);
            this.getterInfoMap.put(getterInfo.getField().getName(), getterInfo);
        }
    }

    public SetterInfo getSetterInfo(String name) {
        return this.setterInfos.get(name);
    }

    public boolean containsSetterKey(String fieldName) {
        return this.setterInfos.containsKey(fieldName);
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public Object newInstance() throws Exception {
        return this.defaultConstructor.newInstance(this.constructorArgs);
    }

    public Object newInstance(Object[] constructorArgs) throws Exception {
        return this.defaultConstructor.newInstance(constructorArgs);
    }

    public boolean isAssignableFromMap() {
        return this.assignableFromMap;
    }

    public boolean isRecord() {
        return this.record;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public boolean isSubEnum() {
        return this.subEnum;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public boolean isForceUseFields() {
        return this.forceUseFields;
    }

    public ClassWrapperType getClassWrapperType() {
        return this.classWrapperType;
    }

    public Object[] createConstructorArgs() {
        Object[] constructorArgs = new Object[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            constructorArgs[i] = this.constructorArgs[i];
        }
        return constructorArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassStrucWrap get(Class<?> sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException("sourceClass is null");
        }
        ClassStrucWrap wrapper = CLASS_STRUC_WRAP_MAP.get(sourceClass);
        if (wrapper != null) {
            return wrapper;
        }
        if (sourceClass.isInterface() || sourceClass.isEnum() || sourceClass.isArray() || sourceClass.isPrimitive()) {
            return null;
        }
        if (wrapper == null) {
            Class<?> clazz = sourceClass;
            synchronized (clazz) {
                if (CLASS_STRUC_WRAP_MAP.containsKey(sourceClass)) {
                    return CLASS_STRUC_WRAP_MAP.get(sourceClass);
                }
                wrapper = ClassStrucWrap.createBy(sourceClass);
                CLASS_STRUC_WRAP_MAP.put(sourceClass, wrapper);
            }
        }
        return wrapper;
    }

    public static ClassStrucWrap ofEnumClass(Class<? extends Enum> enumClass) {
        if (!enumClass.isEnum()) {
            throw new UnsupportedOperationException("not enum class " + enumClass);
        }
        ClassStrucWrap wrapper = ClassStrucWrap.createBy(enumClass);
        wrapper.forceUseFields = true;
        return wrapper;
    }

    private static ClassStrucWrap createBy(Class<?> sourceClass) {
        ClassStrucWrap wrapper = new ClassStrucWrap(sourceClass);
        wrapper.checkClassStructure();
        Type genericSuperclass = sourceClass.getGenericSuperclass();
        HashMap superGenericClassMap = new HashMap();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            Type[] types = parameterizedType.getActualTypeArguments();
            Class superclass = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = superclass.getTypeParameters();
            int i = 0;
            for (TypeVariable typeVariable : typeParameters) {
                Type actualTypeArgument;
                String name = typeVariable.getName();
                if (!((actualTypeArgument = types[i++]) instanceof Class)) continue;
                superGenericClassMap.put(name, (Class)actualTypeArgument);
            }
        }
        if (wrapper.record) {
            ClassStrucWrap.wrapperWithRecordConstructor(wrapper, superGenericClassMap);
        } else {
            ClassStrucWrap.wrapperWithMethodAndField(wrapper, superGenericClassMap);
        }
        return wrapper;
    }

    private static void wrapperWithRecordConstructor(ClassStrucWrap wrapper, Map<String, Class<?>> superGenericClassMap) {
        Class<?> sourceClass = wrapper.sourceClass;
        Constructor<?>[] constructors = sourceClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            return;
        }
        Constructor<?> constructor = null;
        int maxParameterCount = 0;
        for (Constructor<?> c : constructors) {
            if (constructor != null && c.getParameterCount() <= maxParameterCount) continue;
            constructor = c;
            maxParameterCount = constructor.getParameterCount();
        }
        wrapper.defaultConstructor = constructor;
        ClassStrucWrap.setAccessible(constructor);
        ArrayList<GetterInfo> getterInfoOfFields = new ArrayList<GetterInfo>();
        wrapper.getterInfoOfFields = getterInfoOfFields;
        wrapper.getterInfos = getterInfoOfFields;
        try {
            int len;
            Object[] parameters = (Object[])getParametersMethod.invoke(constructor, new Object[0]);
            wrapper.fieldCount = len = parameters.length;
            Method parameterNameMethod = null;
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Object[] constructorArgs = new Object[len];
            wrapper.constructorArgs = constructorArgs;
            HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
            long fieldsCheckCode = 0L;
            for (int i = 0; i < len; ++i) {
                Object parameter = parameters[i];
                if (parameterNameMethod == null) {
                    parameterNameMethod = parameter.getClass().getMethod("getName", new Class[0]);
                    ClassStrucWrap.setAccessible(parameterNameMethod);
                }
                String name = (String)parameterNameMethod.invoke(parameter, new Object[0]);
                fieldsCheckCode = fieldsCheckCode == 0L ? FNV.hash64(name) : FNV.hash64(fieldsCheckCode, name);
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setName(name);
                fieldInfo.setIndex(i);
                Field nameField = sourceClass.getDeclaredField(name);
                ClassStrucWrap.setAccessible(nameField);
                ClassStrucWrap.clearFinalModifiers(nameField);
                Method nameMethod = sourceClass.getDeclaredMethod(name, new Class[0]);
                ClassStrucWrap.setAccessible(nameMethod);
                Class<?> fieldType = nameField.getType();
                constructorArgs[i] = ClassStrucWrap.defaulTypeValue(fieldType);
                GetterMethodInfo getterInfo = new GetterMethodInfo(nameMethod);
                getterInfo.setField(nameField);
                getterInfo.setRecord(true);
                getterInfo.setName(name);
                getterInfo.setUnderlineName(StringUtils.camelCaseToSymbol(name));
                HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                ClassStrucWrap.addAnnotations(annotationMap, nameMethod.getAnnotations());
                getterInfo.setAnnotations(annotationMap);
                getterInfoOfFields.add(getterInfo);
                SetterInfo.FieldImpl setterInfo = new SetterInfo.FieldImpl();
                setterInfo.setName(name);
                ((SetterInfo)setterInfo).setField(nameField);
                setterInfo.setParameterType(fieldType);
                setterInfo.setIndex(i);
                Type genericType = genericParameterTypes[i];
                Class<?> declaringClass = nameField.getDeclaringClass();
                ClassStrucWrap.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, fieldType);
                setterInfo.setAnnotations(annotationMap);
                wrapper.setterInfos.put(name, setterInfo);
                fieldInfo.setGetterInfo(getterInfo);
                fieldInfo.setSetterInfo(setterInfo);
                fieldInfoMap.put(name, fieldInfo);
            }
            wrapper.fieldInfoMap = fieldInfoMap;
            wrapper.fieldsCheckCode = fieldsCheckCode;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void wrapperWithMethodAndField(ClassStrucWrap wrapper, Map<String, Class<?>> superGenericClassMap) {
        Method[] methods;
        Class<?> sourceClass = wrapper.sourceClass;
        boolean globalMIP = wrapper.annotationMap.containsKey(MethodInvokePriority.class);
        Constructor<?>[] constructors = sourceClass.getDeclaredConstructors();
        Constructor<?> defaultConstructor = null;
        int minParamCount = -1;
        Class<?>[] constructorParameterTypes = null;
        block6: for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int parameterCount = parameterTypes.length;
            if (minParamCount == -1 || minParamCount > parameterCount) {
                minParamCount = parameterCount;
                defaultConstructor = constructor;
                constructorParameterTypes = parameterTypes;
            }
            if (minParamCount == 0) break;
            if (minParamCount != parameterCount) continue;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameterTypes[i].isPrimitive() || constructorParameterTypes[i].isPrimitive()) continue;
                defaultConstructor = constructor;
                constructorParameterTypes = parameterTypes;
                continue block6;
            }
        }
        ClassStrucWrap.setAccessible(defaultConstructor);
        Object[] args = new Object[minParamCount];
        for (int i = 0; i < minParamCount; ++i) {
            void type = constructorParameterTypes[i];
            args[i] = ClassStrucWrap.defaulTypeValue(type);
        }
        wrapper.defaultConstructor = defaultConstructor;
        wrapper.constructorArgs = args;
        ArrayList<GetterMethodInfo> getterInfos = new ArrayList<GetterMethodInfo>();
        for (Method method : methods = sourceClass.getMethods()) {
            boolean startsWithGet;
            boolean isVoid;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean bl = isVoid = returnType == Void.TYPE;
            if (parameterTypes.length == 0 && ((startsWithGet = methodName.startsWith("get")) || methodName.startsWith("is")) && !isVoid) {
                HashMap<Class<? extends Annotation>, Annotation> annotationMap;
                GetterMethodInfo getterInfo;
                block22: {
                    boolean boolGetter;
                    int startIndex;
                    int n = startIndex = startsWithGet ? 3 : 2;
                    if (methodName.length() == startIndex) continue;
                    boolean bl2 = boolGetter = !startsWithGet;
                    if (boolGetter && returnType != Boolean.TYPE) continue;
                    ClassStrucWrap.setAccessible(method);
                    getterInfo = new GetterMethodInfo(method);
                    String fieldName = new String(methodName.substring(startIndex));
                    char[] fieldNameChars = UnsafeHelper.getChars(fieldName);
                    if (fieldNameChars.length == 1 || !Character.isUpperCase(fieldNameChars[1])) {
                        fieldNameChars[0] = Character.toLowerCase(fieldNameChars[0]);
                        fieldName = new String(fieldNameChars);
                    }
                    getterInfo.setName(fieldName);
                    getterInfo.setUnderlineName(StringUtils.camelCaseToSymbol(fieldName));
                    annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                    ClassStrucWrap.addAnnotations(annotationMap, method.getAnnotations());
                    if (!globalMIP && !annotationMap.containsKey(MethodInvokePriority.class)) {
                        try {
                            Field field = sourceClass.getDeclaredField(fieldName);
                            if (!Modifier.isStatic(field.getModifiers()) && ClassStrucWrap.setAccessible(field) && ClassStrucWrap.compatibleType(returnType, field.getType())) {
                                getterInfo.setField(field);
                            }
                            ClassStrucWrap.addAnnotations(annotationMap, field.getAnnotations());
                        }
                        catch (Exception e) {
                            if (!boolGetter) break block22;
                            try {
                                Field field = sourceClass.getDeclaredField(methodName);
                                if (!Modifier.isStatic(field.getModifiers()) && ClassStrucWrap.setAccessible(field) && field.getType() == Boolean.TYPE) {
                                    getterInfo.setField(field);
                                    getterInfo.setName(field.getName());
                                }
                            }
                            catch (Exception field) {
                                // empty catch block
                            }
                        }
                    }
                }
                getterInfo.setAnnotations(annotationMap);
                getterInfos.add(getterInfo);
                continue;
            }
            if (parameterTypes.length != 1 || !methodName.startsWith("set") || !isVoid || methodName.length() == 3) continue;
            ClassStrucWrap.setAccessible(method);
            SetterMethodInfo setterInfo = new SetterMethodInfo(method);
            String setFieldName = new String(methodName.substring(3));
            char[] fieldNameChars = UnsafeHelper.getChars(setFieldName);
            if (fieldNameChars.length == 1 || !Character.isUpperCase(fieldNameChars[1])) {
                fieldNameChars[0] = Character.toLowerCase(fieldNameChars[0]);
                setFieldName = new String(fieldNameChars);
            }
            wrapper.setterInfos.put(setFieldName, setterInfo);
            String underlineName = StringUtils.camelCaseToSymbol(setFieldName);
            wrapper.setterInfos.put(underlineName, setterInfo);
            setterInfo.setName(setFieldName);
            Class<?> parameterType = parameterTypes[0];
            setterInfo.setParameterType(parameterType);
            Type genericType = method.getGenericParameterTypes()[0];
            ClassStrucWrap.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, parameterType);
            HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
            Annotation[] methodAnnotations = method.getAnnotations();
            ClassStrucWrap.addAnnotations(annotationMap, methodAnnotations);
            if (!globalMIP && !annotationMap.containsKey(MethodInvokePriority.class)) {
                try {
                    Field field = sourceClass.getDeclaredField(setFieldName);
                    if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                        if (ClassStrucWrap.setAccessible(field) && ClassStrucWrap.compatibleType(field.getType(), parameterType)) {
                            setterInfo.setField(field);
                        } else {
                            setterInfo.setFieldDisabled(true);
                        }
                    }
                    Annotation[] fieldAnnotations = field.getAnnotations();
                    ClassStrucWrap.addAnnotations(annotationMap, fieldAnnotations);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            setterInfo.setAnnotations(annotationMap);
        }
        ClassStrucWrap.parseWrapperFields(wrapper, sourceClass, superGenericClassMap);
        Collections.sort(getterInfos, new Comparator<GetterInfo>(){

            @Override
            public int compare(GetterInfo o1, GetterInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        wrapper.getterInfos = Collections.unmodifiableList(getterInfos);
        wrapper.setterInfos = Collections.unmodifiableMap(wrapper.setterInfos);
        wrapper.fillGetterInfoMap();
        if (wrapper.getterInfos.size() == 0 && wrapper.getterInfoOfFields != null && wrapper.getterInfoOfFields.size() > 0) {
            wrapper.forceUseFields = true;
        }
    }

    private static boolean compatibleType(Class<?> type, Class<?> parameterType) {
        if (type.isAssignableFrom(parameterType)) {
            return true;
        }
        List types = COMPATIBLE_TYPES.get(type);
        if (types == null) {
            return false;
        }
        return types.indexOf(parameterType) > -1;
    }

    private static Object defaulTypeValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type.isPrimitive()) {
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            return 0;
        }
        if (type == String.class) {
            return "";
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        return null;
    }

    private void checkClassStructure() {
        Class<?> theSuperClass;
        String pckName = this.sourceClass.getPackage().getName();
        if (pckName.startsWith("java.") || pckName.startsWith("sun.")) {
            this.javaBuiltInModule = true;
        }
        if ((theSuperClass = this.sourceClass.getSuperclass()) == null) {
            return;
        }
        if (theSuperClass.getName().equals("java.lang.Record")) {
            this.record = true;
            this.javaBuiltInModule = true;
            this.classWrapperType = ClassWrapperType.Record;
        }
        if (theSuperClass.isEnum()) {
            this.subEnum = true;
        }
        if (this.javaBuiltInModule) {
            String className;
            this.forceUseFields = true;
            for (Class superClass : USE_GETTER_METHOD_TYPE_LIST) {
                if (!superClass.isAssignableFrom(this.sourceClass)) continue;
                this.forceUseFields = false;
                break;
            }
            if ((className = this.sourceClass.getName()).equals("java.time.LocalDate")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalDate;
                this.temporal = true;
            } else if (className.equals("java.time.LocalTime")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalTime;
                this.temporal = true;
            } else if (className.equals("java.time.LocalDateTime")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalDateTime;
                this.temporal = true;
            } else if (className.equals("java.time.Instant")) {
                this.classWrapperType = ClassWrapperType.TemporalInstant;
                this.temporal = true;
            } else if (className.equals("java.time.ZonedDateTime")) {
                this.classWrapperType = ClassWrapperType.TemporalZonedDateTime;
                this.temporal = true;
            } else if (className.equals("java.time.OffsetDateTime")) {
                this.classWrapperType = ClassWrapperType.TemporalOffsetDateTime;
                this.temporal = true;
            }
        }
    }

    private static void parseSetterGenericType(Map<String, Class<?>> superGenericClassMap, Class<?> sourceClass, Class<?> declaringClass, SetterInfo setterInfo, Type genericType, Class<?> parameterType) {
        GenericParameterizedType<Object> genericParameterizedType = null;
        if (Collection.class.isAssignableFrom(parameterType)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type type = pt.getActualTypeArguments()[0];
                if (type instanceof Class) {
                    setterInfo.setActualTypeArgument((Class)type);
                }
                genericParameterizedType = GenericParameterizedType.genericCollectionType(parameterType, type);
            } else {
                genericParameterizedType = GenericParameterizedType.createInternal(parameterType);
            }
        } else if (parameterType.isArray()) {
            Class<?> componentType = parameterType.getComponentType();
            setterInfo.setActualTypeArgument(componentType);
            if (genericType instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)genericType;
                Type genericComponentType = genericArrayType.getGenericComponentType();
                genericParameterizedType = GenericParameterizedType.genericArrayType(genericComponentType);
            } else {
                genericParameterizedType = GenericParameterizedType.arrayType(componentType);
            }
        } else if (Map.class.isAssignableFrom(parameterType)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                if (actualTypeArguments.length == 2) {
                    genericParameterizedType = GenericParameterizedType.genericMapType(parameterType, actualTypeArguments[0], actualTypeArguments[1]);
                }
            } else {
                genericParameterizedType = GenericParameterizedType.createInternal(parameterType);
            }
        } else {
            if ((parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers())) && !parameterType.isPrimitive()) {
                setterInfo.setNonInstanceType(true);
            }
            if (genericType instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)genericType;
                String name = typeVariable.getName();
                if (declaringClass != sourceClass) {
                    Class<?> superGenericClass = superGenericClassMap.get(name);
                    genericParameterizedType = GenericParameterizedType.createInternal(superGenericClass);
                } else {
                    genericParameterizedType = GenericParameterizedType.genericEntityType(parameterType, typeVariable.getName());
                }
            } else if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                if (actualTypeArguments.length == 1) {
                    Type actualTypeArgument = actualTypeArguments[0];
                    genericParameterizedType = actualTypeArgument instanceof Class ? GenericParameterizedType.entityType(parameterType, (Class)actualTypeArgument) : GenericParameterizedType.createInternal(parameterType);
                } else {
                    TypeVariable<Class<?>>[] typeParameters = parameterType.getTypeParameters();
                    int i = 0;
                    HashMap genericClassMap = new HashMap();
                    for (TypeVariable<Class<?>> typeVariable : typeParameters) {
                        Type actualTypeArgument;
                        String name = typeVariable.getName();
                        if (!((actualTypeArgument = actualTypeArguments[i++]) instanceof Class)) continue;
                        genericClassMap.put(name, (Class)actualTypeArgument);
                    }
                    genericParameterizedType = GenericParameterizedType.entityType(parameterType, genericClassMap);
                }
            } else {
                genericParameterizedType = GenericParameterizedType.createInternal(parameterType);
            }
        }
        if (genericParameterizedType != null) {
            setterInfo.setGenericParameterizedType(genericParameterizedType);
        }
    }

    private static void parseWrapperFields(ClassStrucWrap wrapper, Class<?> sourceClass, Map<String, Class<?>> superGenericClassMap) {
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<GetterInfo> getterInfoOfFields = new ArrayList<GetterInfo>();
        HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
        int cnt = 0;
        int index = 0;
        long fieldsCheckCode = 0L;
        for (Class<?> target = sourceClass; target != Object.class; target = target.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = target.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                String fieldName = field.getName();
                String underlineName = StringUtils.camelCaseToSymbol(fieldName);
                if (!fieldNames.add(fieldName)) continue;
                ClassStrucWrap.setAccessible(field);
                ClassStrucWrap.clearFinalModifiers(field);
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setName(fieldName);
                fieldInfo.setIndex(index++);
                fieldsCheckCode = fieldsCheckCode == 0L ? FNV.hash64(fieldName) : FNV.hash64(fieldsCheckCode, fieldName);
                Class<?> fieldType = field.getType();
                GetterInfo getterInfo = new GetterInfo();
                getterInfo.setField(field);
                getterInfo.setName(fieldName);
                getterInfo.setUnderlineName(underlineName);
                HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                ClassStrucWrap.addAnnotations(annotationMap, field.getAnnotations());
                getterInfo.setAnnotations(annotationMap);
                getterInfoOfFields.add(getterInfo);
                fieldInfo.setGetterInfo(getterInfo);
                SetterInfo setterInfo = SetterInfo.fromField(field);
                setterInfo.setName(fieldName);
                setterInfo.setField(field);
                setterInfo.setParameterType(fieldType);
                Type genericType = field.getGenericType();
                Class<?> declaringClass = field.getDeclaringClass();
                ClassStrucWrap.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, fieldType);
                setterInfo.setAnnotations(annotationMap);
                getterInfo.setGenericParameterizedType(setterInfo.getGenericParameterizedType());
                SetterInfo oldSetterInfo = wrapper.setterInfos.get(fieldName);
                if (oldSetterInfo == null || !oldSetterInfo.isFieldDisabled()) {
                    wrapper.setterInfos.put(fieldName, setterInfo);
                }
                if (!underlineName.equals(fieldName)) {
                    wrapper.setterInfos.put(underlineName, setterInfo);
                }
                fieldInfo.setSetterInfo(setterInfo);
                fieldInfoMap.put(fieldName, fieldInfo);
            }
            if (++cnt != 100) continue;
            break;
        }
        wrapper.getterInfoOfFields = Collections.unmodifiableList(getterInfoOfFields);
        wrapper.fieldInfoMap = fieldInfoMap;
        wrapper.fieldsCheckCode = fieldsCheckCode;
    }

    private static void clearFinalModifiers(Field field) {
        if (modifierField != null) {
            try {
                modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean setAccessible(AccessibleObject accessibleObject) {
        try {
            boolean accessible = UnsafeHelper.setAccessible(accessibleObject);
            if (accessible) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            accessibleObject.setAccessible(true);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Set<String> setterNames() {
        return this.setterInfos.keySet();
    }

    private static void addAnnotations(Map<Class<? extends Annotation>, Annotation> annotationMap, Annotation[] annotationArr) {
        if (annotationMap == null || annotationArr == null) {
            return;
        }
        for (Annotation annotation : annotationArr) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokePublic(Object invoker, String methodName, Object[] params) {
        List<Method> nameMethods;
        if (this.publicMethods == null) {
            ClassStrucWrap classStrucWrap = this;
            synchronized (classStrucWrap) {
                if (this.publicMethods == null) {
                    Method[] methods;
                    this.publicMethods = new HashMap<String, List<Method>>();
                    for (Method method : methods = this.sourceClass.getMethods()) {
                        String name = method.getName();
                        List<Method> nameMethods2 = this.publicMethods.get(name);
                        if (nameMethods2 == null) {
                            nameMethods2 = new ArrayList<Method>();
                            this.publicMethods.put(name.intern(), nameMethods2);
                        }
                        ClassStrucWrap.setAccessible(method);
                        nameMethods2.add(method);
                    }
                }
            }
        }
        if ((nameMethods = this.publicMethods.get(methodName)) == null) {
            throw new UnsupportedOperationException("method " + methodName + " is not exist or not a public method ");
        }
        try {
            if (nameMethods.size() == 1) {
                Method method = nameMethods.get(0);
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != params.length) {
                    throw new IllegalArgumentException("argument mismatch");
                }
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    Object value = params[i];
                    if (ObjectUtils.isInstance(parameterType, value)) continue;
                    try {
                        params[i] = ObjectUtils.toType(value, parameterType, ReflectConsts.getClassCategory(parameterType));
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw new IllegalArgumentException("argument mismatch: " + parameterType + " ");
                    }
                }
                return method.invoke(invoker, params);
            }
            for (Method method : nameMethods) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != params.length) continue;
                boolean matched = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (params[i] == null || ObjectUtils.isInstance(parameterTypes[i], params[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method.invoke(invoker, params);
            }
            throw new UnsupportedOperationException("method " + methodName + " of " + this.sourceClass + " Parameter mismatch ");
        }
        catch (Throwable throwable) {
            throw new InvokeReflectException(throwable);
        }
    }

    public Set<SetterInfo> setterSet() {
        return new HashSet<SetterInfo>(this.setterInfos.values());
    }

    public FieldInfo[] getFieldInfos() {
        FieldInfo[] fieldInfos = new FieldInfo[this.fieldInfoMap.size()];
        return this.fieldInfoMap.values().toArray(fieldInfos);
    }

    public long getFieldsCheckCode() {
        return this.fieldsCheckCode;
    }

    public boolean isPrivate() {
        return this.privateFlag;
    }

    public boolean isPublic() {
        return this.publicFlag;
    }

    public boolean isJavaBuiltInModule() {
        return this.javaBuiltInModule;
    }

    public Annotation getDeclaredAnnotation(Class<? extends Annotation> annotationClass) {
        return this.annotationMap.get(annotationClass);
    }

    static {
        COMPATIBLE_TYPES.put(Double.TYPE, Arrays.asList(Double.class, Long.TYPE, Long.class, Float.class, Float.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.TYPE, Byte.class));
        COMPATIBLE_TYPES.put(Float.TYPE, Arrays.asList(Long.TYPE, Long.class, Float.class, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.TYPE, Byte.class));
        COMPATIBLE_TYPES.put(Long.TYPE, Arrays.asList(Long.class, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.TYPE, Byte.class));
        COMPATIBLE_TYPES.put(Integer.TYPE, Arrays.asList(Integer.class, Short.class, Short.TYPE, Byte.TYPE, Byte.class));
        COMPATIBLE_TYPES.put(Short.TYPE, Arrays.asList(Short.class, Byte.TYPE, Byte.class));
        COMPATIBLE_TYPES.put(Byte.TYPE, Arrays.asList(Byte.class));
        COMPATIBLE_TYPES.put(Double.class, Arrays.asList(Double.TYPE));
        COMPATIBLE_TYPES.put(Float.class, Arrays.asList(Float.TYPE));
        COMPATIBLE_TYPES.put(Long.class, Arrays.asList(Long.TYPE));
        COMPATIBLE_TYPES.put(Integer.class, Arrays.asList(Integer.TYPE));
        COMPATIBLE_TYPES.put(Short.class, Arrays.asList(Short.TYPE));
        COMPATIBLE_TYPES.put(Byte.class, Arrays.asList(Byte.TYPE));
        Field field = null;
        try {
            field = Field.class.getDeclaredField("modifiers");
            ClassStrucWrap.setAccessible(field);
        }
        catch (Exception e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                ClassStrucWrap.setAccessible(getDeclaredFields0);
                for (Field target : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(target.getName())) continue;
                    field = target;
                    ClassStrucWrap.setAccessible(field);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        modifierField = field;
        Method parametersMethod = null;
        try {
            parametersMethod = Method.class.getMethod("getParameters", new Class[0]);
            parametersMethod.setAccessible(true);
            ClassStrucWrap.setAccessible(parametersMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getParametersMethod = parametersMethod;
    }

    public static enum ClassWrapperType {
        Normal,
        Record,
        TemporalLocalDate,
        TemporalLocalDateTime,
        TemporalLocalTime,
        TemporalInstant,
        TemporalZonedDateTime,
        TemporalOffsetDateTime;

    }
}

