/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public final class ByteUtils {
    public static byte[] memset(int c, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)c;
        }
        return buffer;
    }

    public static byte[] memcpy(byte[] src, int start, int len) {
        byte[] buffer = new byte[len];
        System.arraycopy(src, start, buffer, 0, len);
        return buffer;
    }

    public static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        for (int i = 0; i < len && bytes[i] != 0; ++i) {
            sb.append((char)bytes[i]);
        }
        return sb.toString();
    }

    public static byte[] toBytes(String str, int size) {
        int len = str == null ? 0 : str.length();
        byte[] bytes = new byte[size];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)str.charAt(i);
            }
        }
        return bytes;
    }

    public static int writeInt(byte[] buf, int offset, int value) {
        buf[offset++] = (byte)(value >> 24 & 0xFF);
        buf[offset++] = (byte)(value >> 16 & 0xFF);
        buf[offset++] = (byte)(value >> 8 & 0xFF);
        buf[offset] = (byte)(value & 0xFF);
        return 4;
    }

    public static int writeLong(byte[] buf, int offset, long value) {
        buf[offset++] = (byte)(value >> 56 & 0xFFL);
        buf[offset++] = (byte)(value >> 48 & 0xFFL);
        buf[offset++] = (byte)(value >> 40 & 0xFFL);
        buf[offset++] = (byte)(value >> 32 & 0xFFL);
        buf[offset++] = (byte)(value >> 24 & 0xFFL);
        buf[offset++] = (byte)(value >> 16 & 0xFFL);
        buf[offset++] = (byte)(value >> 8 & 0xFFL);
        buf[offset] = (byte)(value & 0xFFL);
        return 8;
    }

    public static int readInt(byte[] buf, int offset) {
        int value = 0;
        value |= (buf[offset++] & 0xFF) << 24;
        value |= (buf[offset++] & 0xFF) << 16;
        value |= (buf[offset++] & 0xFF) << 8;
        return value |= buf[offset] & 0xFF;
    }

    public static long readLong(byte[] buf, int offset) {
        long value = 0L;
        long mask = 255L;
        value |= ((long)buf[offset++] & mask) << 56;
        value |= ((long)buf[offset++] & mask) << 48;
        value |= ((long)buf[offset++] & mask) << 40;
        value |= ((long)buf[offset++] & mask) << 32;
        value |= ((long)buf[offset++] & mask) << 24;
        value |= ((long)buf[offset++] & mask) << 16;
        value |= ((long)buf[offset++] & mask) << 8;
        return value |= (long)buf[offset] & mask;
    }

    public static float readFloat(byte[] buf, int off) {
        int bits = ByteUtils.readInt(buf, off);
        return Float.intBitsToFloat(bits);
    }

    public static double readDouble(byte[] buf, int off) {
        long bits = ByteUtils.readLong(buf, off);
        return Double.longBitsToDouble(bits);
    }

    public static String toBinaryString(byte[] b, char splitChar) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String bits = Integer.toBinaryString(b[i] & 0xFF);
            int count = bits.length();
            while (count++ < 8) {
                builder.append('0');
            }
            builder.append(bits);
            if (splitChar <= '\u0000') continue;
            builder.append(splitChar);
        }
        return builder.toString();
    }

    public static String hexToBinaryString(String hexString) {
        char[] chars;
        StringBuilder builder = new StringBuilder();
        for (char ch : chars = hexString.toCharArray()) {
            int numIndex;
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) {
                builder.append(ch);
                continue;
            }
            String bits = Integer.toBinaryString(numIndex);
            int count = bits.length();
            while (count++ < 4) {
                builder.append('0');
            }
            builder.append(bits);
        }
        return builder.toString();
    }

    public static String printHexString(byte[] b) {
        return ByteUtils.printHexString(b, '\u0000');
    }

    public static String printHexString(byte[] b, char splitChar) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex.toUpperCase());
            if (splitChar <= '\u0000') continue;
            builder.append(splitChar);
        }
        return builder.toString();
    }

    public static byte[] hexString2Bytes(String hexString) {
        char[] chars = hexString.toCharArray();
        return ByteUtils.hexString2Bytes(chars, 0, chars.length);
    }

    public static byte[] hexString2Bytes(char[] chars, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase(chars[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        return ByteUtils.memcpy(bytes, 0, byteLength);
    }

    public static byte[] readStreamBytes(InputStream is) throws IOException {
        return IOUtils.readBytes(is);
    }
}

