/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.utils.ED;
import io.github.wycst.wast.common.utils.ED5;
import io.github.wycst.wast.common.utils.EF;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.Scientific;
import java.math.BigInteger;
import java.util.Arrays;

public final class NumberUtils {
    static final double[] POSITIVE_DECIMAL_POWER = new double[325];
    static final double[] NEGATIVE_DECIMAL_POWER = new double[325];
    static final long[] POW10_LONG_VALUES = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final long[] POW5_LONG_VALUES = new long[27];
    static final BigInteger[] POW5_BI_VALUES = new BigInteger[343];
    static final int MOD_DOUBLE_EXP = 4095;
    static final int MOD_FLOAT_EXP = 511;
    static final long MOD_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    static final int MOD_FLOAT_MANTISSA = 0x7FFFFF;

    public static char[] copyDigitOnes() {
        return Arrays.copyOf(DigitOnes, DigitOnes.length);
    }

    public static char[] copyDigitTens() {
        return Arrays.copyOf(DigitTens, DigitTens.length);
    }

    public static double getDecimalPowerValue(int expValue) {
        if (expValue < POSITIVE_DECIMAL_POWER.length) {
            return POSITIVE_DECIMAL_POWER[expValue];
        }
        return Math.pow(10.0, expValue);
    }

    public static int stringSize(long value) {
        int i = 1;
        if (value < 0L) {
            ++i;
            value = -value;
        }
        for (long val : POW10_LONG_VALUES) {
            if (value < val) {
                return i;
            }
            ++i;
        }
        return 19;
    }

    public static int digitDecimal(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return ch - 48;
            }
        }
        return -1;
    }

    public static boolean isDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public static int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(int c1, int c2, int c3, int c4) {
        int v4;
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3)) | (v4 = NumberUtils.digitDecimal(c4))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}) + "\"");
        }
        return v1 * 1000 + v2 * 100 + v3 * 10 + v4;
    }

    public static int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(int c1, int c2) throws NumberFormatException {
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2}) + "\"");
        }
        return v1 * 10 + v2;
    }

    public static int parseInt1(char[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static int parseInt1(byte[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static String toHexString16(long value) {
        char[] chars = new char[16];
        for (int i = 15; i > -1; --i) {
            int val = (int)(value & 0xFL);
            chars[i] = HEX_DIGITS[val];
            value >>= 4;
        }
        return new String(chars);
    }

    public static double scientificToIEEEDouble(long val, int scale) {
        long e2;
        boolean oddFlag;
        long l;
        int mask;
        int sr;
        if (val < 1L) {
            if (val == Long.MIN_VALUE) {
                val = Long.MAX_VALUE;
            } else {
                return 0.0;
            }
        }
        int leadingZeros = Long.numberOfLeadingZeros(val);
        if (scale < 1) {
            long l2;
            int mmask;
            int mask2;
            int sr2;
            if (scale == 0) {
                return val;
            }
            int e10 = -scale;
            if (e10 < 23 && val < 0x20000000000001L) {
                return (double)val * POSITIVE_DECIMAL_POWER[e10];
            }
            if (e10 > 308) {
                return Double.POSITIVE_INFINITY;
            }
            ED5 ed5 = ED5.ED5_A[e10];
            long left = val << leadingZeros - 1;
            long h = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(left, ed5.y);
            if (h > 0x1FFFFFFFFFFFFFFFL) {
                sr2 = 9;
                mask2 = 255;
                mmask = 511;
            } else {
                sr2 = 8;
                mask2 = 127;
                mmask = 255;
            }
            long e = e10 + ed5.dfb + 1140 - leadingZeros + sr2;
            if ((h & (long)mmask) != (long)mask2 || (l2 = left * ed5.y) > 0L || !NumberUtils.checkLowCarry(l2, left, ed5.f + 1L)) {
                return NumberUtils.longBitsToIntegerDouble(h, e, sr2);
            }
            if (NumberUtils.checkLowCarry(l2, left, ed5.f)) {
                return NumberUtils.longBitsToIntegerDouble(h + 1L, e, sr2);
            }
            int e52 = e10 - leadingZeros + ed5.dfb + sr2 + 65;
            if (e52 >= 972) {
                return Double.POSITIVE_INFINITY;
            }
            long mantissa0 = h >>> sr2;
            long rightSum = (mantissa0 << 1) + 1L;
            int sb = 1 - e52 + e10;
            BigInteger multiplier = POW5_BI_VALUES[e10];
            long diff = BigInteger.valueOf(val).multiply(multiplier).compareTo(BigInteger.valueOf(rightSum).shiftLeft(-sb));
            if ((diff > 0L || diff == 0L && (mantissa0 & 1L) == 1L) && ++mantissa0 == 0x20000000000000L) {
                mantissa0 = 0x10000000000000L;
                ++e52;
            }
            long e22 = e52 + 1075;
            long bits = e22 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
            return Double.longBitsToDouble(bits);
        }
        if (scale > 342) {
            return 0.0;
        }
        ED5 ed5 = ED5.ED5_A[scale];
        long left = val << leadingZeros - 1;
        long h = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(left, ed5.oy);
        if (h > 0x1FFFFFFFFFFFFFFFL) {
            sr = 9;
            mask = 255;
        } else {
            sr = 8;
            mask = 127;
        }
        int e52 = 33 - scale - ed5.ob - leadingZeros + sr;
        if ((h & (long)mask) != (long)mask || e52 > -1075 && (h >> sr - 1 & 1L) == 1L || (l = left * ed5.oy) > 0L || !NumberUtils.checkLowCarry(l, left, ed5.of + 1L)) {
            return NumberUtils.longBitsToDecimalDouble(h, e52, sr);
        }
        if (NumberUtils.checkLowCarry(l, left, ed5.of)) {
            return NumberUtils.longBitsToDecimalDouble(h + 1L, e52, sr);
        }
        if (scale < POW5_LONG_VALUES.length) {
            long diff;
            long p5sv = POW5_LONG_VALUES[scale];
            long mantissa0 = h >>> sr;
            long e23 = e52 + 1075;
            long bits = e23 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
            double dv0 = Double.longBitsToDouble(bits);
            int sb = 1 - scale - e52;
            long l3 = diff = sb > 0 ? (val << sb) - (mantissa0 << 1) * p5sv - p5sv : val - (mantissa0 << 1 - sb) * p5sv - (p5sv << -sb);
            if (diff > 0L || diff == 0L && (mantissa0 & 1L) == 1L) {
                return Double.longBitsToDouble(bits + 1L);
            }
            return dv0;
        }
        BigInteger divisor = POW5_BI_VALUES[scale];
        long mantissa0 = h >>> sr;
        boolean bl = oddFlag = (mantissa0 & 1L) == 1L;
        if (e52 < -1074) {
            e2 = 0L;
            if ((sr += -1074 - e52) >= 62) {
                return 0.0;
            }
        } else {
            e2 = e52 + 1075;
        }
        long rightSum = (mantissa0 << 1) + 1L;
        int sb = 1 - e52 - scale;
        long diff = BigInteger.valueOf(val).shiftLeft(sb).compareTo(divisor.multiply(BigInteger.valueOf(rightSum)));
        if ((diff > 0L || diff == 0L && oddFlag) && ++mantissa0 == 0x20000000000000L) {
            mantissa0 = 0x10000000000000L;
            ++e2;
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    private static boolean checkLowCarry(long l, long x, long y32) {
        return l + ((EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y32) << 32) + (x * y32 >>> 32)) > -1L;
    }

    static double longBitsToDecimalDouble(long l62, int e52, int sr) {
        long mantissa0;
        long e2;
        if (e52 < -1074) {
            e2 = 0L;
            if ((sr += -1074 - e52) > 61) {
                return 0.0;
            }
            mantissa0 = (l62 >> sr - 1) + 1L >> 1;
        } else {
            e2 = e52 + 1075;
            mantissa0 = (l62 >>> sr - 1) + 1L >> 1;
            if (mantissa0 == 0x20000000000000L) {
                mantissa0 = 0x10000000000000L;
                ++e2;
            }
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    static double longBitsToIntegerDouble(long l62, long e2, int sr) {
        if (e2 > 2046L) {
            return Double.POSITIVE_INFINITY;
        }
        long mantissa0 = (l62 >>> sr - 1) + 1L >> 1;
        if (mantissa0 == 0x20000000000000L) {
            mantissa0 = 0x10000000000000L;
            ++e2;
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    public static float scientificToIEEEFloat(long val, int scale) {
        float val0;
        if (val < 1L) {
            return 0.0f;
        }
        float fv = val;
        if (scale < 1) {
            if (scale == 0) {
                return fv;
            }
            int e10 = -scale;
            if (e10 > 38) {
                return Float.POSITIVE_INFINITY;
            }
            double dv = (double)val * NumberUtils.getDecimalPowerValue(e10);
            val0 = (float)dv;
        } else {
            if (scale > 63) {
                return 0.0f;
            }
            double dv = (double)val / NumberUtils.getDecimalPowerValue(scale);
            val0 = (float)dv;
        }
        return val0;
    }

    static long multiplyHighAndShift(long x, long y, int shift) {
        long H = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y);
        if (shift >= 64) {
            int sr = shift - 64;
            return H >>> sr;
        }
        long L = x * y;
        return H << 64 - shift | L >>> shift;
    }

    static long multiplyHighAndShift(long x, long y, long y32, int s) {
        int sr = s - 64;
        long H = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y);
        long L = x * y;
        long H1 = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y32);
        long L1 = x * y32;
        long carry = (H1 << 32) + (L1 >>> 32);
        long L2 = L + carry;
        if ((L | carry) < 0L && ((L & carry) < 0L || L2 >= 0L)) {
            ++H;
        }
        L = L2;
        if (sr >= 0) {
            return H >>> sr;
        }
        return H << -sr | L >>> s;
    }

    public static Scientific doubleToScientific(double doubleValue) {
        long output;
        long rawOutput;
        long d4;
        long d3;
        int adl;
        int e10;
        int e52;
        boolean flagForDown;
        if (doubleValue == Double.MIN_VALUE) {
            return Scientific.DOUBLE_MIN;
        }
        long bits = Double.doubleToRawLongBits(doubleValue);
        int e2 = (int)(bits >> 52) & 0xFFF;
        long mantissa0 = bits & 0xFFFFFFFFFFFFFL;
        boolean bl = flagForDown = mantissa0 > 0L;
        if (e2 > 0) {
            if (e2 == 2047) {
                return Scientific.SCIENTIFIC_NULL;
            }
            mantissa0 = 0x10000000000000L | mantissa0;
            e52 = e2 - 1075;
        } else {
            int lz52 = Long.numberOfLeadingZeros(mantissa0) - 11;
            mantissa0 <<= lz52;
            e52 = -1074 - lz52;
        }
        boolean accurate = false;
        if (e52 >= 0) {
            ED d = ED.E2_D_A[e52];
            e10 = d.e10;
            adl = d.adl;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else if (doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                    return new Scientific(e10 + 1, true);
                }
            }
            int o5 = d.o5;
            int sb = e52 + o5;
            if (o5 < 0) {
                ED5 d5 = ED5.ED5_A[-o5];
                int rb = sb - 10 - d5.ob;
                rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, d5.oy, d5.of, 32 - rb);
                accurate = o5 == -1 && sb < 11;
            } else {
                rawOutput = mantissa0 * POW5_LONG_VALUES[o5] << sb;
                accurate = true;
            }
        } else {
            int o5;
            int sb;
            int e5 = -e52;
            ED d = ED.E5_D_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else {
                    if (e10 >= -1 && doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                    if (e10 < -1 && doubleValue == NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                }
            }
            if ((sb = (o5 = d.o5) + e52) < 0) {
                if (o5 < POW5_LONG_VALUES.length) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0, POW5_LONG_VALUES[o5], -sb);
                } else if (o5 < POW5_LONG_VALUES.length + 4) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 * POW5_LONG_VALUES[o5 - POW5_LONG_VALUES.length + 1], POW5_LONG_VALUES[POW5_LONG_VALUES.length - 1], -sb);
                } else {
                    ED5 ed5 = ED5.ED5_A[o5];
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, ed5.y, ed5.f, -(ed5.dfb + sb) + 10);
                }
            } else {
                rawOutput = POW5_LONG_VALUES[o5] * mantissa0 << sb;
            }
        }
        if (accurate) {
            rawOutput /= 10L;
            if (adl == 16) {
                --adl;
                rawOutput = (rawOutput + 5L) / 10L;
            }
            return new Scientific(rawOutput, adl + 2, e10);
        }
        long div = rawOutput / 1000L;
        long rem = rawOutput - div * 1000L;
        long remUp = 10001L - rem * 10L << 1;
        boolean up = remUp <= d4;
        if (up || rem + 1L << (flagForDown ? 1 : 2) <= d3) {
            output = div + (long)(up ? 1 : 0);
            --adl;
        } else if (flagForDown) {
            output = (rawOutput + 50L) / 100L;
        } else {
            output = (rawOutput + 5L) / 10L;
            ++adl;
        }
        return new Scientific(output, adl + 1, e10);
    }

    public static Scientific floatToScientific(float floatValue) {
        long output;
        boolean up;
        long rawOutput;
        long d4;
        int adl;
        int e10;
        int e23;
        int bits = Float.floatToRawIntBits(floatValue);
        int e2 = bits >> 23 & 0x1FF;
        int mantissa0 = bits & 0x7FFFFF;
        boolean nonZeroFlag = mantissa0 > 0;
        boolean accurate = false;
        if (e2 > 0) {
            mantissa0 = 0x800000 | mantissa0;
            e23 = e2 - 150;
        } else {
            int l = Integer.numberOfLeadingZeros(mantissa0) - 8;
            mantissa0 <<= l;
            e23 = -149 - l;
        }
        if (e23 >= 0) {
            ED d = EF.E2_F_A[e23];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
            int o5 = d.o5 + 6;
            int sb = e23 + o5;
            if (o5 < 0) {
                if (sb < 40) {
                    rawOutput = ((long)mantissa0 << sb) / POW5_LONG_VALUES[-o5];
                } else {
                    ED5 d5 = ED5.ED5_A[-o5];
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 << 39, d5.oy, d5.of, 71 + d5.ob - sb);
                }
            } else {
                rawOutput = (long)mantissa0 * POW5_LONG_VALUES[o5] << sb;
                accurate = true;
            }
        } else {
            int o5;
            int sb;
            int e5 = -e23;
            ED d = EF.E5_F_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
            if ((sb = (o5 = d.o5 + 6) + e23) < 0) {
                if (o5 < 17) {
                    rawOutput = (long)mantissa0 * POW5_LONG_VALUES[o5] >> -sb;
                } else if (o5 < POW5_LONG_VALUES.length) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0, POW5_LONG_VALUES[o5], -sb);
                } else if (o5 < POW5_LONG_VALUES.length + 4) {
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 * POW5_LONG_VALUES[o5 - POW5_LONG_VALUES.length + 1], POW5_LONG_VALUES[POW5_LONG_VALUES.length - 1], -sb);
                } else {
                    ED5 ed5 = ED5.ED5_A[o5];
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 << 39, ed5.y, ed5.f, -(ed5.dfb + sb) + 39);
                }
            } else {
                rawOutput = POW5_LONG_VALUES[o5] * (long)mantissa0 << sb;
                accurate = true;
            }
        }
        if (accurate) {
            // empty if block
        }
        if (rawOutput < 1000000000L) {
            return new Scientific(EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(rawOutput, 7737125245533626719L) >> 22, 2, e10);
        }
        long div = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(rawOutput, 4951760157141521100L) >> 28;
        long rem = rawOutput - div * 1000000000L;
        long remUp = 1000000001L - rem << 1;
        boolean bl = up = remUp <= d4;
        if (up || rem + 1L << (nonZeroFlag ? 1 : 2) <= d4) {
            output = div + (long)(up ? 1 : 0);
            if (up && POW10_LONG_VALUES[--adl] == output) {
                ++e10;
                output = 1L;
                adl = 0;
            }
        } else if (nonZeroFlag) {
            long div0 = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(rawOutput, 6189700196426901375L) >> 25;
            output = div0 + (long)(rem % 100000000L >= 50000000L ? 1 : 0);
        } else {
            long div0 = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(rawOutput, 7737125245533626719L) >> 22;
            output = div0 + (long)(rem % 10000000L >= 5000000L ? 1 : 0);
            ++adl;
        }
        return new Scientific(output, adl + 1, e10);
    }

    public static boolean equals(long val, String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (val == Long.MIN_VALUE) {
            return text.equals("-9223372036854775808");
        }
        long result = 0L;
        long len = text.length();
        int i = 0;
        if (text.charAt(0) == '-') {
            ++i;
            val = -val;
        }
        while ((long)i < len) {
            int d = NumberUtils.digitDecimal(text.charAt(i));
            if (d == -1) {
                return false;
            }
            result = result * 10L + (long)d;
            ++i;
        }
        return val == result;
    }

    static {
        int len = POSITIVE_DECIMAL_POWER.length;
        for (int i = 0; i < len; ++i) {
            NumberUtils.POSITIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E" + i);
            NumberUtils.NEGATIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E-" + i);
        }
        NumberUtils.NEGATIVE_DECIMAL_POWER[NumberUtils.NEGATIVE_DECIMAL_POWER.length - 1] = Double.MIN_VALUE;
        long val = 1L;
        for (int i = 0; i < POW5_LONG_VALUES.length; ++i) {
            NumberUtils.POW5_LONG_VALUES[i] = val;
            val *= 5L;
        }
        BigInteger five = BigInteger.valueOf(5L);
        NumberUtils.POW5_BI_VALUES[0] = BigInteger.ONE;
        for (int i = 1; i < POW5_BI_VALUES.length; ++i) {
            BigInteger pow5Value;
            NumberUtils.POW5_BI_VALUES[i] = pow5Value = five.pow(i);
        }
    }
}

