/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.jdbc.connection.ConnectionWraper;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.SqlExecuterProperties;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class TemporaryExecuter
extends DefaultSqlExecuter {
    private final TemporaryConnectionWraper connectionWraper;

    public static TemporaryExecuter create(DataSource dataSource) {
        return new TemporaryExecuter(dataSource);
    }

    public static TemporaryExecuter create(DataSource dataSource, SqlExecuterProperties properties) {
        return new TemporaryExecuter(dataSource, properties);
    }

    TemporaryExecuter(DataSource dataSource) {
        dataSource.getClass();
        this.setDataSource(dataSource);
        this.connectionWraper = new TemporaryConnectionWraper(dataSource);
    }

    TemporaryExecuter(DataSource dataSource, SqlExecuterProperties properties) {
        super(properties);
        dataSource.getClass();
        this.setDataSource(dataSource);
        this.connectionWraper = new TemporaryConnectionWraper(dataSource);
    }

    @Override
    protected final Connection getConnection() {
        return this.connectionWraper.getConnection();
    }

    @Override
    protected final ConnectionWraper getConnectionWraper() {
        return this.connectionWraper;
    }

    @Override
    public final void beginTransaction() {
        this.connectionWraper.beginTransaction();
    }

    @Override
    public final void commitTransaction() {
        this.commitTransaction(false);
    }

    @Override
    public final void commitTransaction(boolean closeConnection) {
        this.connectionWraper.commitTransaction(closeConnection);
    }

    @Override
    public final void endTransaction() {
        this.connectionWraper.endTransaction();
    }

    @Override
    public final void rollbackTransaction() {
        this.rollbackTransaction(false);
    }

    @Override
    public final void rollbackTransaction(boolean closeConnection) {
        this.connectionWraper.rollbackTransaction(closeConnection);
    }

    @Override
    public void close() {
        this.connectionWraper.close();
    }

    final class TemporaryConnectionWraper
    extends ConnectionWraper {
        private DataSource dataSource;
        private boolean closed;

        TemporaryConnectionWraper(DataSource dataSource) {
            super(null);
            this.dataSource = dataSource;
        }

        @Override
        public boolean autoClose() {
            return false;
        }

        @Override
        public synchronized Connection getConnection() {
            if (this.closed) {
                throw new SqlExecuteException("Connection is closed");
            }
            if (this.physicalConn == null) {
                try {
                    this.physicalConn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    throw new SqlExecuteException(e.getMessage(), e);
                }
            }
            return this.physicalConn;
        }

        @Override
        public void close() {
            super.close();
            this.closed = true;
        }

        public void beginTransaction() {
            try {
                this.getConnection().setAutoCommit(false);
                this.setTransaction(true);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void commitTransaction(boolean closeConnection) {
            if (this.physicalConn != null) {
                try {
                    if (this.isTransaction()) {
                        this.physicalConn.commit();
                    }
                    if (closeConnection) {
                        this.physicalConn.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void rollbackTransaction(boolean closeConnection) {
            if (this.physicalConn != null) {
                try {
                    if (this.isTransaction()) {
                        this.physicalConn.rollback();
                    }
                    if (closeConnection) {
                        this.physicalConn.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void endTransaction() {
            try {
                this.physicalConn.setAutoCommit(true);
                this.setTransaction(false);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

