/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.helper;

import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.commands.SqlExecuteCall;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SqlHelper {
    public static Map<String, String> reverse(DefaultSqlExecuter sqlExecuter, final String tableName, final String[] includeInsertColumns, final String[] includeSelectColumns) {
        final HashMap<String, String> reverseResults = new HashMap<String, String>();
        final String querySql = String.format("select * from %s where 1 = 2 ", tableName);
        StringBuilder insertStatement = new StringBuilder("insert into " + tableName);
        final StringBuilder insertColumnNames = new StringBuilder();
        final StringBuilder columnValues = new StringBuilder();
        StringBuilder selectStatement = new StringBuilder("select  ");
        final StringBuilder selectColumnNames = new StringBuilder();
        final StringBuilder entityBuffer = new StringBuilder();
        entityBuffer.append("\nimport io.github.wycst.wast.jdbc.annotations.*;\n");
        entityBuffer.append("\nimport io.github.wycst.wast.jdbc.annotations.Id.GenerationType;\n");
        entityBuffer.append("@lombok.Data\n");
        entityBuffer.append("@Table(name = \"" + tableName + "\")\n");
        entityBuffer.append("public class " + StringUtils.getCamelCase(tableName, true) + " implements java.io.Serializable {\n\n");
        sqlExecuter.executePipelined(new SqlExecuteCall<Object>(){

            @Override
            public Object execute(Connection connection) throws SQLException {
                try {
                    PreparedStatement ps = connection.prepareStatement(querySql);
                    ResultSet rs = ps.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    String primaryColumnName = null;
                    try {
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        ResultSet pkRSet = databaseMetaData.getPrimaryKeys(null, null, tableName);
                        if (pkRSet.next()) {
                            primaryColumnName = pkRSet.getString(4);
                        }
                        pkRSet.close();
                    }
                    catch (Throwable databaseMetaData) {
                        // empty catch block
                    }
                    int deleteColumnNameDotIndex = -1;
                    int deleteColumValueDotIndex = -1;
                    int deleteColumSelectDotIndex = -1;
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = rsmd.getColumnLabel(i);
                        String columnCamelCase = StringUtils.getCamelCase(columnName);
                        if (includeInsertColumns == null || StringUtils.contains(includeInsertColumns, columnName)) {
                            insertColumnNames.append(columnName).append(",");
                            columnValues.append("#{" + columnCamelCase + "},");
                            deleteColumnNameDotIndex = insertColumnNames.length() - 1;
                            deleteColumValueDotIndex = columnValues.length() - 1;
                        }
                        if (includeSelectColumns == null || StringUtils.contains(includeSelectColumns, columnName)) {
                            selectColumnNames.append("t." + columnName + ",");
                            deleteColumSelectDotIndex = selectColumnNames.length() - 1;
                        }
                        int size = rsmd.getColumnDisplaySize(i);
                        int columnType = rsmd.getColumnType(i);
                        String javaType = "Integer";
                        if (columnType == 93 || columnType == 91) {
                            javaType = "java.util.Date";
                        } else if (columnType == 8 || columnType == 6) {
                            javaType = "Double";
                        } else if (columnType == -5) {
                            javaType = "Long";
                        } else if (columnType == 4) {
                            javaType = "Integer";
                        } else if (columnType == 12 || columnType == -9 || columnType == 2005 || columnType == -1) {
                            javaType = "String";
                        } else if (columnType == 1) {
                            javaType = "String";
                        } else if (columnType == -4) {
                            javaType = "byte[]";
                        } else {
                            System.out.println(columnName);
                            throw new RuntimeException(" type  validate error ");
                        }
                        if (primaryColumnName != null && primaryColumnName.equalsIgnoreCase(columnName)) {
                            entityBuffer.append("    @Id\n");
                        }
                        entityBuffer.append("    @Column(name = \"" + columnName + "\")\n");
                        entityBuffer.append("    private " + javaType + " " + columnCamelCase + ";\n\n");
                        if (columnCamelCase.indexOf("create") > -1 && javaType.equals("java.util.Date")) {
                            reverseResults.put("createDateColumn", columnCamelCase);
                        }
                        if (!columnCamelCase.matches(".*([uU]pdate|[mM]odify).*") || !javaType.equals("java.util.Date")) continue;
                        reverseResults.put("updateDateColumn", columnCamelCase);
                    }
                    if (deleteColumnNameDotIndex > -1) {
                        insertColumnNames.deleteCharAt(deleteColumnNameDotIndex);
                    }
                    if (deleteColumValueDotIndex > -1) {
                        columnValues.deleteCharAt(deleteColumValueDotIndex);
                    }
                    if (deleteColumSelectDotIndex > -1) {
                        selectColumnNames.deleteCharAt(deleteColumSelectDotIndex);
                    }
                    rs.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return null;
            }
        });
        insertStatement.append("(" + insertColumnNames + ") values(" + columnValues + ")");
        reverseResults.put("insert-sql", insertStatement.toString());
        selectStatement.append((CharSequence)selectColumnNames).append(" from ").append(tableName).append(" t ");
        reverseResults.put("select-sql", selectStatement.toString());
        entityBuffer.append("\n");
        entityBuffer.append("}");
        reverseResults.put("entity-code", entityBuffer.toString());
        return reverseResults;
    }

    public static String generateSqlByEntity(Object tableEntity, String[] includeInsertFields, String[] includeSelectFields) {
        return null;
    }
}

