/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONUnsafe;

final class AsciiStringSource
implements CharSource {
    private final String input;

    public AsciiStringSource(String input) {
        this.input = input;
    }

    public static AsciiStringSource of(String input) {
        return new AsciiStringSource(input);
    }

    @Override
    public String input() {
        return this.input;
    }

    @Override
    public String substring(byte[] bytes, int beginIndex, int endIndex) {
        return JSONUnsafe.createAsciiString(bytes, beginIndex, endIndex - beginIndex);
    }

    @Override
    public void writeString(JSONCharArrayWriter writer, byte[] buf, int offset, int len) {
        writer.writeString(this.input, offset, len);
    }
}

