/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONReaderHook;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class JSONAbstractReader
extends JSONGeneral {
    int pos;
    int bufferSize = 8192;
    int count;
    int offset;
    int current;
    JSONReaderHook readerHook;
    final JSONParseContext parseContext = new JSONParseContext();
    final StringBuilder writer = new StringBuilder();
    ReadOption[] readOptions = new ReadOption[0];
    Object result;
    boolean reading;
    boolean closed;
    boolean aborted;
    boolean completed;
    int readingOffset = -1;
    volatile CountDownLatch countDownLatch = new CountDownLatch(1);
    boolean async;
    long timeout = 60000L;
    long currentThreadId;
    boolean multiple;

    JSONAbstractReader() {
    }

    public void setOptions(ReadOption ... readOptions) {
        this.readOptions = readOptions;
        JSONOptions.readOptions(readOptions, this.parseContext);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public abstract Object read();

    public void read(boolean async) {
        this.read(null, async);
    }

    public <T> T readAsResult(Class<T> actualType) {
        return this.readAsResult(GenericParameterizedType.actualType(actualType));
    }

    public <T> T readAsResult(GenericParameterizedType<T> genericType) {
        this.executeReadStream(genericType);
        return (T)this.result;
    }

    public void read(JSONReaderHook readerHook) {
        this.read(readerHook, false);
    }

    public void read(JSONReaderHook readerHook, boolean async) {
        if (this.reading) {
            return;
        }
        this.checkReadState();
        this.readerHook = readerHook;
        this.reading = true;
        if (!async) {
            this.executeReadStream(null);
        } else {
            this.async = true;
            this.currentThreadId = Thread.currentThread().getId();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JSONAbstractReader.this.executeReadStream(null);
                }
            }).start();
        }
    }

    public final void skipNext() {
        try {
            if (this.current == 0) {
                this.readBuffer();
            }
            this.clearWhitespaces();
            switch (this.current) {
                case 123: {
                    this.skipObject();
                    break;
                }
                case 91: {
                    this.skipArray();
                    break;
                }
                case -1: {
                    this.complete();
                    break;
                }
                default: {
                    throw new JSONException("character stream start character error for '" + (char)this.current + "'. the start token is only supported  '{' or '[' on multiple mode");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void skipNext(int count) {
        while (count-- > 0) {
            this.skipNext();
        }
    }

    private void complete() {
        this.result = null;
        this.completed = true;
    }

    private void checkReadState() {
        if (this.closed || this.aborted) {
            throw new UnsupportedOperationException("reader is closed or aborted");
        }
    }

    private void executeReadStream(GenericParameterizedType genericType) {
        try {
            this.readBuffer();
            this.beginReadWithType(genericType);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        finally {
            this.tryCloseReader();
            this.reading = false;
            this.closed = true;
            this.unlock();
        }
    }

    abstract void readBuffer() throws IOException;

    private void unlock() {
        this.countDownLatch.countDown();
    }

    final void defaultRead() throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.result = this.readObject();
                break;
            }
            case 91: {
                this.result = this.readArray();
                break;
            }
            case -1: {
                this.complete();
                return;
            }
            default: {
                throw new JSONException("character stream start character error for '" + (char)this.current + "'. the start token is only supported  '{' or '[' on multiple mode");
            }
        }
        if (!this.multiple) {
            this.clearWhitespaces();
            if (this.current > -1) {
                throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
            }
        }
    }

    private void beginReadWithType(GenericParameterizedType genericType) throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.result = this.readObject("", genericType);
                break;
            }
            case 91: {
                this.result = this.readArray("", genericType);
                break;
            }
            case -1: {
                this.complete();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
            }
        }
        if (this.isAborted()) {
            return;
        }
        if (!this.multiple) {
            this.clearWhitespaces();
            if (this.current > -1) {
                throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
            }
        }
        if (this.readerHook != null) {
            this.readerHook.onCompleted(this.result);
        }
    }

    private Object readObject() throws Exception {
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                return instance;
            }
            if (this.current == 34 || this.current == 39) {
                int token = this.current;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != token) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    switch (this.current) {
                        case 123: {
                            instance.put(key, this.readObject());
                            break;
                        }
                        case 91: {
                            instance.put(key, this.readArray());
                            break;
                        }
                        case 34: {
                            instance.put(key, this.readString());
                            break;
                        }
                        case 110: {
                            this.readNull();
                            instance.put(key, null);
                            break;
                        }
                        case 116: {
                            this.readTrue();
                            instance.put(key, true);
                            break;
                        }
                        case 102: {
                            this.readFalse();
                            instance.put(key, false);
                            break;
                        }
                        default: {
                            instance.put(key, this.readNumber('}'));
                            if (this.current != 125) continue block8;
                            return instance;
                        }
                    }
                    this.clearWhitespaces();
                    if (this.current == 44) continue;
                    if (this.current == 125) {
                        return instance;
                    }
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void readTrue() throws Exception {
        if (this.readNext(true) == 114 && this.readNext(true) == 117 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readFalse() throws Exception {
        if (this.readNext(true) == 97 && this.readNext(true) == 108 && this.readNext(true) == 115 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readNull() throws Exception {
        if (this.readNext(true) == 117 && this.readNext(true) == 108 && this.readNext(true) == 108) {
            return;
        }
        this.throwUnexpectedException();
    }

    private Number readNumber(char endSyntax) throws Exception {
        double doubleVal;
        int specifySuffix;
        int mode;
        boolean expNegative;
        int expValue;
        int decimalCount;
        long value;
        boolean negative;
        block39: {
            block40: {
                boolean useBigDecimal = this.parseContext.useBigDecimalAsDefault;
                if (useBigDecimal) {
                    int ch;
                    this.writer.setLength(0);
                    this.writer.append((char)this.current);
                    while ((ch = this.readNext()) != 44 && ch != endSyntax) {
                        this.writer.append((char)ch);
                    }
                    String text = this.writer.toString();
                    try {
                        return new BigDecimal(text.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NumberFormatException("offset " + this.offset + ", error input " + text);
                    }
                }
                negative = false;
                char beginChar = (char)this.current;
                if (beginChar == '-') {
                    negative = true;
                    this.readNext();
                } else if (beginChar == '+') {
                    this.readNext();
                }
                value = 0L;
                decimalCount = 0;
                expValue = 0;
                expNegative = false;
                mode = 0;
                specifySuffix = 0;
                while (NumberUtils.isDigit(this.current)) {
                    value = (value << 3) + (value << 1) + (long)this.current - 48L;
                    this.readNext();
                }
                if (this.current == 46) {
                    mode = 1;
                    while (NumberUtils.isDigit(this.readNext())) {
                        value = (value << 3) + (value << 1) + (long)this.current - 48L;
                        ++decimalCount;
                    }
                }
                if (this.current <= 32) {
                    while (this.readNext() <= 32) {
                    }
                }
                if (this.current == 44 || this.current == endSyntax) break block39;
                if (this.current != 69 && this.current != 101) break block40;
                mode = 2;
                expNegative = this.readNext() == 45;
                if (expNegative || this.current == 43) {
                    this.readNext();
                }
                if (NumberUtils.isDigit(this.current)) {
                    expValue = this.current - 48;
                    while (NumberUtils.isDigit(this.readNext())) {
                        expValue = (expValue << 3) + (expValue << 1) + this.current - 48;
                    }
                }
                if (this.current == 44 || this.current == endSyntax) break block39;
            }
            switch (this.current) {
                case 76: 
                case 108: {
                    if (specifySuffix == 0) {
                        specifySuffix = 1;
                        while (this.readNext() <= 32) {
                        }
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                case 70: 
                case 102: {
                    if (specifySuffix == 0) {
                        specifySuffix = 2;
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                case 68: 
                case 100: {
                    if (specifySuffix == 0) {
                        specifySuffix = 3;
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                default: {
                    this.throwUnexpectedException();
                }
            }
        }
        if (mode == 0) {
            long l = value = negative ? -value : value;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return Float.valueOf(value);
                    }
                }
                return value;
            }
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            return value;
        }
        double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
        double d = doubleVal = negative ? -dv : dv;
        if (specifySuffix > 0) {
            switch (specifySuffix) {
                case 1: {
                    return (long)doubleVal;
                }
                case 2: {
                    return Float.valueOf((float)doubleVal);
                }
            }
            return doubleVal;
        }
        return doubleVal;
    }

    private Object readArray() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                return arrayList;
            }
            switch (this.current) {
                case 123: {
                    Object value = this.readObject();
                    arrayList.add(value);
                    break;
                }
                case 91: {
                    Object value = this.readArray();
                    arrayList.add(value);
                    break;
                }
                case 34: {
                    Object value = this.readString();
                    arrayList.add(value);
                    break;
                }
                case 110: {
                    this.readNull();
                    arrayList.add(null);
                    break;
                }
                case 116: {
                    this.readTrue();
                    arrayList.add(true);
                    break;
                }
                case 102: {
                    this.readFalse();
                    arrayList.add(false);
                    break;
                }
                default: {
                    Object value = this.readNumber(']');
                    arrayList.add(value);
                    if (this.current != 93) continue block8;
                    return arrayList;
                }
            }
            this.clearWhitespaces();
            if (this.current == 44) continue;
            if (this.current == 93) {
                return arrayList;
            }
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    Object readObject(String path, GenericParameterizedType genericType) throws Exception {
        LinkedHashMap instance;
        boolean useHookValueParse;
        GenericParameterizedType valueType;
        boolean useHook;
        ClassStrucWrap classStrucWrap;
        Map map;
        block34: {
            block31: {
                block32: {
                    block33: {
                        map = null;
                        classStrucWrap = null;
                        useHook = this.readerHook != null;
                        valueType = null;
                        boolean bl = useHookValueParse = useHook && genericType == null;
                        if (genericType != null) break block31;
                        if (!useHook) break block32;
                        if (!this.readerHook.filter(path, 1)) {
                            this.skipObject();
                            return null;
                        }
                        genericType = this.readerHook.getParameterizedType(path);
                        if (genericType != null) break block33;
                        instance = this.readerHook.createdMap(path);
                        break block34;
                    }
                    useHookValueParse = false;
                    break block31;
                }
                map = new LinkedHashMap();
                instance = map;
                break block34;
            }
            Class<?> actualType = genericType.getActualType();
            ReflectConsts.ClassCategory classCategory = genericType.getActualClassCategory();
            if (classCategory == ReflectConsts.ClassCategory.ObjectCategory) {
                classStrucWrap = ClassStrucWrap.get(actualType);
                if (classStrucWrap == null) {
                    throw new UnsupportedOperationException(actualType + " is not supported the path: " + path);
                }
                instance = classStrucWrap.newInstance();
            } else if (classCategory == ReflectConsts.ClassCategory.MapCategory) {
                map = JSONAbstractReader.createMapInstance(genericType);
                instance = map;
                valueType = genericType.getValueType();
                if (valueType == null) {
                    valueType = GenericParameterizedType.AnyType;
                }
            } else if (classCategory == ReflectConsts.ClassCategory.ANY) {
                map = new LinkedHashMap();
                instance = map;
                valueType = GenericParameterizedType.AnyType;
            } else {
                throw new UnsupportedOperationException(actualType + " is not supported the path: " + path);
            }
        }
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                return instance;
            }
            if (this.current == 34 || this.current == 39) {
                int token = this.current;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != token) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    boolean toBreakOrContinue = false;
                    SetterInfo setterInfo = null;
                    JsonProperty jsonProperty = null;
                    boolean isSkipValue = false;
                    if (classStrucWrap != null) {
                        setterInfo = classStrucWrap.getSetterInfo(key);
                        boolean bl = isSkipValue = setterInfo == null;
                        if (!isSkipValue) {
                            jsonProperty = (JsonProperty)setterInfo.getAnnotation(JsonProperty.class);
                            valueType = setterInfo.getGenericParameterizedType();
                        }
                    }
                    if (isSkipValue) {
                        this.skipValue('}');
                    } else {
                        String nextPath = useHook ? path + "/" + key : null;
                        switch (this.current) {
                            case 123: {
                                Object value = this.readObject(nextPath, valueType);
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 1);
                                break;
                            }
                            case 91: {
                                Object value = this.readArray(nextPath, valueType);
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 2);
                                break;
                            }
                            case 34: {
                                Object value = this.parseStringTo(this.readString(), valueType, jsonProperty);
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 3);
                                break;
                            }
                            case 110: {
                                this.readNull();
                                this.invokeValueOfObject(useHookValueParse, key, null, map, instance, setterInfo, nextPath, 6);
                                break;
                            }
                            case 116: {
                                this.readTrue();
                                Object value = this.toBoolType(true, valueType);
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 5);
                                break;
                            }
                            case 102: {
                                this.readFalse();
                                Object value = this.toBoolType(false, valueType);
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 5);
                                break;
                            }
                            default: {
                                Object value = this.parseNumberTo(this.readNumber('}'), valueType);
                                toBreakOrContinue = true;
                                this.invokeValueOfObject(useHookValueParse, key, value, map, instance, setterInfo, nextPath, 4);
                            }
                        }
                        if (this.isAborted()) {
                            return instance;
                        }
                        if (this.readerHook != null && this.readerHook.isAbored()) {
                            this.abortRead();
                            return instance;
                        }
                        if (!toBreakOrContinue) {
                            this.clearWhitespaces();
                        }
                    }
                    if (this.current == 125) break;
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
        if (this.readerHook != null && this.readerHook.isAboredOnParsed(instance, path, 1)) {
            this.abortRead();
        }
        return instance;
    }

    final Object readArray(String path, GenericParameterizedType genericType) throws Exception {
        boolean useHookValueParse;
        boolean useHook;
        boolean isArrayCls;
        Class<?> actualType;
        GenericParameterizedType<?> valueType;
        Collection collection;
        Collection instance;
        block25: {
            Class<?> collectionCls;
            block22: {
                block23: {
                    block24: {
                        instance = null;
                        collection = null;
                        collectionCls = null;
                        valueType = null;
                        actualType = null;
                        isArrayCls = false;
                        useHook = this.readerHook != null;
                        boolean bl = useHookValueParse = useHook && genericType == null;
                        if (genericType != null) break block22;
                        if (!useHook) break block23;
                        if (!this.readerHook.filter(path, 2)) {
                            this.skipArray();
                            return null;
                        }
                        genericType = this.readerHook.getParameterizedType(path);
                        if (genericType != null) break block24;
                        instance = collection = this.readerHook.createdCollection(path);
                        break block25;
                    }
                    useHookValueParse = false;
                    break block22;
                }
                if (collectionCls == null || collectionCls == ArrayList.class) {
                    collection = new ArrayList();
                } else {
                    isArrayCls = collectionCls.isArray();
                    if (isArrayCls) {
                        collection = new ArrayList();
                        actualType = collectionCls.getComponentType();
                        if (valueType == null) {
                            valueType = GenericParameterizedType.actualType(actualType);
                        }
                    } else {
                        collection = JSONAbstractReader.createCollectionInstance(collectionCls);
                    }
                }
                instance = collection;
                break block25;
            }
            collectionCls = genericType.getActualType();
            isArrayCls = collectionCls.isArray();
            valueType = genericType.getValueType();
            if (valueType == null) {
                valueType = GenericParameterizedType.AnyType;
            }
            actualType = valueType.getActualType();
            instance = collection = JSONAbstractReader.createCollectionInstance(collectionCls);
        }
        int elementIndex = 0;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                return isArrayCls ? CollectionUtils.toArray(collection, actualType == null ? Object.class : actualType) : collection;
            }
            boolean toBreakOrContinue = false;
            String nextPath = useHook ? path + "/" + elementIndex : null;
            switch (this.current) {
                case 123: {
                    Object value = this.readObject(nextPath, valueType);
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 1);
                    break;
                }
                case 91: {
                    Object value = this.readArray(nextPath, valueType);
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 2);
                    break;
                }
                case 34: {
                    Object value = this.parseStringTo(this.readString(), valueType, null);
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 3);
                    break;
                }
                case 110: {
                    this.readNull();
                    this.parseCollectionElement(useHookValueParse, null, collection, instance, elementIndex, nextPath, 6);
                    break;
                }
                case 116: {
                    this.readTrue();
                    Object value = this.toBoolType(true, valueType);
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 5);
                    break;
                }
                case 102: {
                    this.readFalse();
                    Object value = this.toBoolType(false, valueType);
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 5);
                    break;
                }
                default: {
                    Object value = this.parseNumberTo(this.readNumber(']'), valueType);
                    toBreakOrContinue = true;
                    this.parseCollectionElement(useHookValueParse, value, collection, instance, elementIndex, nextPath, 4);
                    break;
                }
            }
            if (this.isAborted()) {
                return isArrayCls ? CollectionUtils.toArray(collection, actualType == null ? Object.class : actualType) : collection;
            }
            if (this.readerHook != null && this.readerHook.isAbored()) {
                this.abortRead();
                return isArrayCls ? CollectionUtils.toArray(collection, actualType == null ? Object.class : actualType) : collection;
            }
            ++elementIndex;
            if (!toBreakOrContinue) {
                this.clearWhitespaces();
            }
            if (this.current == 93) break;
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
        if (this.readerHook != null && this.readerHook.isAboredOnParsed(instance, path, 2)) {
            this.abortRead();
        }
        return isArrayCls ? CollectionUtils.toArray(collection, actualType == null ? Object.class : actualType) : collection;
    }

    private Object toBoolType(boolean b, GenericParameterizedType valueType) {
        if (valueType == null) {
            return b;
        }
        if (valueType.getActualClassCategory() == ReflectConsts.ClassCategory.BoolCategory) {
            return b;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == AtomicBoolean.class) {
            return new AtomicBoolean(b);
        }
        throw new JSONException("boolean value " + b + " is mismatch " + actualType);
    }

    private void skipValue(char endChar) throws Exception {
        switch (this.current) {
            case 123: {
                this.skipObject();
                this.clearWhitespaces();
                break;
            }
            case 91: {
                this.skipArray();
                this.clearWhitespaces();
                break;
            }
            case 34: {
                this.skipString();
                this.clearWhitespaces();
                break;
            }
            default: {
                this.skipSimple(endChar);
            }
        }
    }

    private void skipObject() throws Exception {
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                return;
            }
            if (this.current == 34) {
                while (this.readNext() > -1 && this.current != 34) {
                }
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    this.skipValue('}');
                    if (this.current == 125) {
                        return;
                    }
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void skipArray() throws Exception {
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                return;
            }
            this.skipValue(']');
            if (this.current == 93) {
                return;
            }
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    private void skipString() throws Exception {
        int prev = 0;
        while (this.readNext() > -1) {
            if (this.current == 34 && prev != 92) {
                return;
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
    }

    private void skipSimple(char endChar) throws Exception {
        while (this.readNext() > -1) {
            if (this.current != 44 && this.current != endChar) continue;
            return;
        }
        this.throwUnexpectedException();
    }

    void beginReading(int n) {
        this.writer.setLength(0);
        this.readingOffset = this.offset + n;
    }

    abstract String endReadingAsString(int var1);

    void endReading(int n) {
        this.endReading(n, -1);
    }

    abstract void endReading(int var1, int var2);

    private Object parseNumberTo(Object simpleValue, GenericParameterizedType valueType) {
        ReflectConsts.ClassCategory classCategory;
        if (simpleValue == null) {
            return null;
        }
        if (valueType == null || (classCategory = valueType.getActualClassCategory()) == ReflectConsts.ClassCategory.ANY) {
            return simpleValue;
        }
        Class<?> actualType = valueType.getActualType();
        if (ObjectUtils.isInstance(actualType, simpleValue)) {
            return simpleValue;
        }
        Number numValue = (Number)simpleValue;
        if (classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return ObjectUtils.toTypeNumber(numValue, actualType);
        }
        if (classCategory == ReflectConsts.ClassCategory.EnumCategory) {
            int ordinal = numValue.intValue();
            Enum[] values = (Enum[])actualType.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("value " + numValue + " is mismatch enum " + actualType);
        }
        throw new JSONException("read simple value " + numValue + " is mismatch " + actualType);
    }

    private Object parseStringTo(String value, GenericParameterizedType valueType, JsonProperty jsonProperty) throws Exception {
        if (value == null) {
            return null;
        }
        if (valueType == null || valueType == GenericParameterizedType.AnyType) {
            return value;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == String.class || actualType == CharSequence.class) {
            return value;
        }
        JSONTypeDeserializer deserializer = JSONTypeDeserializer.getFieldDeserializer(valueType, jsonProperty);
        return deserializer.valueOf(value, actualType);
    }

    private void invokeValueOfObject(boolean useHookParse, String key, Object value, Map map, Object instance, SetterInfo setterInfo, String nextPath, int type) throws Exception {
        if (useHookParse) {
            this.readerHook.parseValue(key, value, instance, -1, nextPath, type);
        } else if (setterInfo != null) {
            JSON_SECURE_TRUSTED_ACCESS.set(setterInfo, instance, value);
        } else if (map != null) {
            map.put(key, value);
        }
    }

    private void parseCollectionElement(boolean useHookParse, Object value, Collection collection, Object instance, int elementIndex, String nextPath, int type) throws Exception {
        if (useHookParse) {
            this.readerHook.parseValue(null, value, instance, elementIndex, nextPath, type);
        } else {
            collection.add(value);
        }
    }

    final void abortRead() {
        this.aborted = true;
    }

    public final boolean isAborted() {
        return this.aborted;
    }

    final void throwUnexpectedException() {
        throw new JSONException("Syntax error, unexpected '" + (char)this.current + "', position " + this.pos);
    }

    final String readString() throws Exception {
        this.beginReading(0);
        int prev = 0;
        while (this.readNext() > -1) {
            if (prev == 92) {
                if (this.offset == 1) {
                    int bufferLen = this.writer.length();
                    this.writer.setLength(bufferLen - 1);
                }
                switch (this.current) {
                    case 34: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\"');
                        break;
                    }
                    case 110: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\n');
                        break;
                    }
                    case 114: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\r');
                        break;
                    }
                    case 116: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\t');
                        break;
                    }
                    case 98: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\b');
                        break;
                    }
                    case 102: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\f');
                        break;
                    }
                    case 117: {
                        long c64;
                        this.endReading(-2, this.offset);
                        this.readingOffset = -1;
                        int c1 = this.readNext(true);
                        int c2 = this.readNext(true);
                        int c3 = this.readNext(true);
                        int c4 = this.readNext(true);
                        try {
                            c64 = JSONAbstractReader.hex4ToLong(c1, c2, c3, c4);
                            if (c64 < 0L) {
                                throw new JSONException("Syntax error, from pos " + this.offset + ", invalid unicode " + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}));
                            }
                        }
                        catch (Throwable throwable) {
                            throw new JSONException("Syntax error, from pos " + this.offset + ", invalid unicode " + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}));
                        }
                        char c = (char)c64;
                        this.readingOffset = this.offset;
                        this.writer.append(c);
                        break;
                    }
                    case 92: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\\');
                        break;
                    }
                    default: {
                        this.endReading(-2, this.offset);
                        this.writer.append((char)this.current);
                    }
                }
                prev = 0;
                continue;
            }
            if (this.current == 34) {
                return this.endReadingAsString(-1);
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
        return null;
    }

    abstract int readNext() throws Exception;

    final int readNext(boolean check) throws Exception {
        this.readNext();
        if (check && this.current == -1) {
            this.tryCloseReader();
            throw new JSONException("Unexpected error, stream is end ");
        }
        return this.current;
    }

    private void clearWhitespaces() throws Exception {
        while (this.readNext() > -1 && this.current <= 32) {
        }
    }

    abstract boolean isCompleted();

    public Object getResult() {
        return this.getResult(this.timeout);
    }

    public Object getResult(long timeout) {
        if (this.async) {
            long threadId = Thread.currentThread().getId();
            if (threadId != this.currentThreadId) {
                return this.result;
            }
            this.await(timeout);
        }
        return this.result;
    }

    private void await(long timeout) {
        try {
            this.countDownLatch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void tryCloseReader() {
        this.writer.setLength(0);
        if (!this.multiple) {
            this.close();
        }
    }

    public abstract void close();

    public JSONAbstractReader multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public JSONAbstractReader options(ReadOption[] readOptions) {
        this.readOptions = readOptions;
        return this;
    }
}

