/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;

class JSONCharArrayWriter
extends JSONWriter {
    char[] buf;
    int count;
    static final char[] EMPTY_BUF = new char[0];
    private static final BufCache[] CHAR_BUF_CACHES = new BufCache[CACHE_COUNT];
    private Charset charset;
    private BufCache bufCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufCache getCharBufCache() {
        BufCache cache;
        int cacheIndex = (Integer)THREAD_CACHE_INDEX.get();
        BufCache bufCache = cache = CHAR_BUF_CACHES[cacheIndex];
        synchronized (bufCache) {
            if (cache.inUse) {
                return null;
            }
            cache.inUse = true;
            if (cache.cacheChars == null) {
                cache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
        }
        return cache;
    }

    void setCharAt(int index, char c) {
        this.buf[index] = c;
    }

    protected char[] toChars() {
        return Arrays.copyOf(this.buf, this.count);
    }

    JSONCharArrayWriter(Charset charset) {
        this();
        this.charset = charset == null ? EnvUtils.CHARSET_DEFAULT : charset;
    }

    JSONCharArrayWriter() {
        BufCache bufCache = JSONCharArrayWriter.getCharBufCache();
        if (bufCache != null) {
            this.buf = bufCache.cacheChars;
            this.bufCache = bufCache;
        } else {
            this.buf = new char[512];
        }
    }

    JSONCharArrayWriter(int cap) {
        this.buf = new char[cap];
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(129);
        this.buf[this.count++] = (char)c;
    }

    public void writeDirect(char c) {
        this.buf[this.count++] = c;
    }

    @Override
    public void writeJSONToken(char c) {
        this.buf[this.count++] = c;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count += len;
    }

    char[] ensureCapacity(int increment) {
        return this.expandCapacity(this.count + increment);
    }

    char[] expandCapacity(long minCap) {
        if (minCap > (long)this.buf.length) {
            if (minCap >= 0x60000000L) {
                throw new UnsupportedOperationException("Expansion failed, data is too large : " + minCap);
            }
            long newCap = Math.min((minCap >> 1) * 3L, 0x60000000L);
            this.buf = Arrays.copyOf(this.buf, (int)newCap);
        } else if (minCap < 0L) {
            throw new UnsupportedOperationException("The data length is too large and has overflowed");
        }
        return this.buf;
    }

    public void writeBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        String str = new String(bytes, offset, len);
        len = str.length();
        this.ensureCapacity(len);
        str.getChars(0, len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        int count = this.count;
        for (int i = 0; i < len; ++i) {
            this.buf[count++] = str.charAt(off++);
        }
        this.count = count;
    }

    public void writeString(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        str.getChars(off, off + len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    protected StringBuffer toStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append(this.buf, 0, this.count);
        return stringBuffer;
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.count);
        stringBuilder.append(this.buf, 0, this.count);
        return stringBuilder;
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        String source;
        byte[] bytes;
        boolean isByteArrayOs = os.getClass() == ByteArrayOutputStream.class;
        boolean emptyByteArrayOs = false;
        if (isByteArrayOs) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)os;
            boolean bl = emptyByteArrayOs = byteArrayOutputStream.size() == 0;
        }
        if ((bytes = (byte[])JSONUnsafe.getStringValue(source = new String(this.buf, 0, this.count))).length == this.count) {
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, this.count);
            } else {
                os.write(bytes, 0, this.count);
            }
        } else if (this.charset == null || this.charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, output);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, length);
            } else {
                os.write(output, 0, length);
            }
        } else {
            bytes = source.getBytes(this.charset);
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, bytes.length);
            } else {
                os.write(bytes);
            }
        }
        os.flush();
    }

    @Override
    protected byte[] toBytes(Charset charset) {
        String source = new String(this.buf, 0, this.count);
        byte[] bytes = (byte[])JSONUnsafe.getStringValue(source);
        if (bytes.length == this.count) {
            return bytes;
        }
        if (charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            return Arrays.copyOf(output, length);
        }
        bytes = source.getBytes(charset);
        return bytes;
    }

    @Override
    protected boolean endsWith(int c) {
        return this.count == 0 ? false : this.buf[this.count - 1] == c;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public final void writeShortChars(char[] chars, int offset, int len) {
        this.ensureCapacity(len + 128);
        int count = this.count;
        for (int i = 0; i < len; ++i) {
            this.buf[count++] = chars[offset++];
        }
        this.count = count;
    }

    final void writeShortJSONChars(char[] chars) {
        long v64;
        int len = chars.length;
        this.ensureCapacity(len + 130);
        int count = this.count;
        this.buf[count++] = 34;
        int limit = len - 4;
        int offset = 0;
        while (offset <= limit && JSONGeneral.isNoneEscaped4Chars(v64 = JSONUnsafe.getLong(chars, offset))) {
            JSONUnsafe.putLong(this.buf, count, v64);
            offset += 4;
            count += 4;
        }
        while (offset < len) {
            String escapeStr;
            char ch = chars[offset];
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
                this.buf[count++] = ch;
            } else {
                int escapesLen = escapeStr.length();
                this.ensureCapacity(escapesLen + 128);
                for (int j = 0; j < escapesLen; ++j) {
                    this.buf[count++] = escapeStr.charAt(j);
                }
            }
            ++offset;
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public final void writeLong(long numValue) throws IOException {
        this.ensureCapacity(148);
        if (numValue < 1L) {
            if (numValue == 0L) {
                this.buf[this.count++] = 48;
                return;
            }
            if (numValue == Long.MIN_VALUE) {
                this.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += JSONCharArrayWriter.writeLong(numValue, this.buf, this.count);
    }

    @Override
    public void writeInt(int numValue) throws IOException {
        this.ensureCapacity(139);
        if (numValue < 1) {
            if (numValue == 0) {
                this.buf[this.count++] = 48;
                return;
            }
            if (numValue == Integer.MIN_VALUE) {
                this.write("-2147483648");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += JSONCharArrayWriter.writeInteger(numValue, this.buf, this.count);
    }

    @Override
    protected final void writeCommaLongValues(long val1, long val2) throws IOException {
        this.ensureCapacity(170);
        int off = this.count;
        if (val1 < 0L) {
            if (val1 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val1 = -val1;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONCharArrayWriter.writeLong(val1, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONCharArrayWriter.writeLong(val1, this.buf, off);
        }
        if (val2 < 0L) {
            if (val2 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val2 = -val2;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONCharArrayWriter.writeLong(val2, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONCharArrayWriter.writeLong(val2, this.buf, off);
        }
        this.count = off;
    }

    @Override
    public final void writeUUID(UUID uuid) {
        this.ensureCapacity(166);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONCharArrayWriter.writeUUID(uuid, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeDouble(double numValue) {
        this.ensureCapacity(152);
        int off = this.count;
        off += JSONCharArrayWriter.writeDouble(numValue, this.buf, off);
        this.count = off;
    }

    @Override
    public final void writeFloat(float numValue) {
        this.ensureCapacity(152);
        this.count += JSONCharArrayWriter.writeFloat(numValue, this.buf, this.count);
    }

    @Override
    public final void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        this.ensureCapacity(164);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeLong((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(hour, 'T', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[minute]);
        this.buf[off++] = 58;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = JSONCharArrayWriter.writeNano(nano, this.buf, off);
        }
        if (zoneId.length() == 1) {
            off += JSONUnsafe.putInt(this.buf, off, Z_QUOT_INT);
            this.count = off;
        } else {
            this.count = off;
            this.writeZoneId(zoneId);
            this.buf[this.count++] = 34;
        }
    }

    @Override
    public final void writeJSONLocalDate(int year, int month, int day) {
        this.ensureCapacity(141);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeLong((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeTime(int hourOfDay, int minute, int second) {
        this.ensureCapacity(138);
        int off = this.count;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        this.count = off;
    }

    @Override
    public final void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) {
        this.ensureCapacity(150);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = JSONCharArrayWriter.writeNano(nano, this.buf, off);
        }
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.ensureCapacity(152);
        int off = this.count;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeLong((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(month, '-', '-'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(hourOfDay, ' ', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[minute]);
        this.buf[off++] = 58;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        this.count = off;
    }

    @Override
    public final void writeBigInteger(BigInteger bigInteger) {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        this.ensureCapacity(increment + 128);
        this.count += JSONCharArrayWriter.writeBigInteger(bigInteger, this.buf, this.count);
    }

    @Override
    public void writeJSONChars(char[] chars) throws IOException {
        int len = chars.length;
        if (len < 64) {
            this.writeShortJSONChars(chars);
        } else {
            this.ensureCapacity(len + 130);
            int count = this.count;
            int beginIndex = 0;
            this.buf[count++] = 34;
            for (int i = JSONGeneral.JSON_UTIL.toNoEscapeOffset(chars, 0); i < len; ++i) {
                String escapeStr;
                char ch = chars[i];
                if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
                int length = i - beginIndex;
                this.expandCapacity(length + count + 133);
                if (length > 0) {
                    System.arraycopy(chars, beginIndex, this.buf, count, length);
                    count += length;
                }
                int escapesLen = escapeStr.length();
                escapeStr.getChars(0, escapesLen, this.buf, count);
                count += escapesLen;
                beginIndex = i + 1;
            }
            int length = len - beginIndex;
            System.arraycopy(chars, beginIndex, this.buf, count, length);
            count += length;
            this.buf[count++] = 34;
            this.count = count;
        }
    }

    static final int escapeBytesToChars(byte[] bytes, int begin, char[] buf, int offset) {
        int len = bytes.length;
        for (int i = begin; i < len; ++i) {
            int b = bytes[i] & 0xFF;
            if (JSONCharArrayWriter.isNoEscape(b)) {
                buf[offset++] = (char)b;
                continue;
            }
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
            int escapesLen = escapeStr.length();
            escapeStr.getChars(0, escapesLen, buf, offset);
            offset += escapesLen;
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int count;
        block9: {
            int len;
            block10: {
                int b;
                int i;
                block15: {
                    int b1;
                    block16: {
                        block13: {
                            int b3;
                            int b2;
                            block14: {
                                block11: {
                                    block12: {
                                        len = bytes.length;
                                        this.ensureCapacity(len + 130);
                                        count = this.count;
                                        this.buf[count++] = 34;
                                        if (len > 15) break block10;
                                        i = 0;
                                        if (i > len - 8) break block11;
                                        if (JSONGeneral.isNoneEscaped8Bytes(JSONUnsafe.getLong(bytes, i))) break block12;
                                        count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                                        break block9;
                                    }
                                    this.buf[count] = (char)bytes[i];
                                    this.buf[count + 1] = (char)bytes[i + 1];
                                    this.buf[count + 2] = (char)bytes[i + 2];
                                    this.buf[count + 3] = (char)bytes[i + 3];
                                    this.buf[count + 4] = (char)bytes[i + 4];
                                    this.buf[count + 5] = (char)bytes[i + 5];
                                    this.buf[count + 6] = (char)bytes[i + 6];
                                    this.buf[count + 7] = (char)bytes[i + 7];
                                    count += 8;
                                    i += 8;
                                }
                                if (i > len - 4) break block13;
                                b = bytes[i] & 0xFF;
                                if (JSONCharArrayWriter.isNoEscape(b) && JSONCharArrayWriter.isNoEscape(b1 = bytes[i + 1] & 0xFF) && JSONCharArrayWriter.isNoEscape(b2 = bytes[i + 2] & 0xFF) && JSONCharArrayWriter.isNoEscape(b3 = bytes[i + 3] & 0xFF)) break block14;
                                count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                                break block9;
                            }
                            this.buf[count] = (char)b;
                            this.buf[count + 1] = (char)b1;
                            this.buf[count + 2] = (char)b2;
                            this.buf[count + 3] = (char)b3;
                            count += 4;
                            i += 4;
                        }
                        if (i > len - 2) break block15;
                        b = bytes[i] & 0xFF;
                        if (JSONCharArrayWriter.isNoEscape(b) && JSONCharArrayWriter.isNoEscape(b1 = bytes[i + 1] & 0xFF)) break block16;
                        count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                        break block9;
                    }
                    this.buf[count] = (char)b;
                    this.buf[count + 1] = (char)b1;
                    count += 2;
                    i += 2;
                }
                if (i < len) {
                    b = bytes[i] & 0xFF;
                    if (JSONCharArrayWriter.isNoEscape(b)) {
                        this.buf[count++] = (char)b;
                        break block9;
                    } else {
                        String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
                        int escapesLen = escapeStr.length();
                        for (int j = 0; j < escapesLen; ++j) {
                            this.buf[count++] = escapeStr.charAt(j);
                        }
                    }
                }
                break block9;
            }
            int beginIndex = 0;
            int i = 0;
            if (JSONGeneral.isNoneEscaped8Bytes(JSONUnsafe.getLong(bytes, i)) && JSONGeneral.isNoneEscaped8Bytes(JSONUnsafe.getLong(bytes, i += 8))) {
                i += 8;
            }
            while (i < len) {
                int b = bytes[i] & 0xFF;
                if (!JSONGeneral.NO_ESCAPE_FLAGS[b]) {
                    String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
                    int length = i - beginIndex;
                    this.expandCapacity(length + count + 8);
                    if (length > 0) {
                        value.getChars(beginIndex, i, this.buf, count);
                        count += length;
                    }
                    int escapesLen = escapeStr.length();
                    escapeStr.getChars(0, escapesLen, this.buf, count);
                    count += escapesLen;
                    beginIndex = i + 1;
                }
                ++i;
            }
            int length = len - beginIndex;
            if (length > 0) {
                value.getChars(beginIndex, len, this.buf, count);
                count += length;
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public final void writeLatinString(String str) throws IOException {
        int len = str.length();
        this.ensureCapacity(len + 128);
        str.getChars(0, len, this.buf, this.count);
        this.count += len;
    }

    @Override
    final void writeMemory(long fourChars, int fourBytes, int len) throws IOException {
        JSONUnsafe.putLong(this.buf, this.count, fourChars);
        this.count += len;
    }

    @Override
    void writeMemory(long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        JSONUnsafe.putLong(this.buf, this.count, fourChars1);
        JSONUnsafe.putLong(this.buf, this.count + 4, fourChars2);
        this.count += len;
    }

    @Override
    final void writeMemory(long[] fourChars, long[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        this.ensureCapacity((n << 2) + 128);
        int count = this.count;
        for (long fourChar : fourChars) {
            JSONUnsafe.putLong(this.buf, count, fourChar);
            count += 4;
        }
        this.count += totalCount;
    }

    @Override
    public final void writeEmptyArray() throws IOException {
        this.ensureCapacity(130);
        this.count += JSONUnsafe.putInt(this.buf, this.count, EMPTY_ARRAY_INT);
    }

    @Override
    public void writeAsBase64String(byte[] src) throws IOException {
        this.ensureCapacity((src.length << 1) + 2);
        int count = this.count;
        this.buf[count++] = 34;
        count += Base64Utils.encode(src, this.buf, count);
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeAsHexString(byte[] src) throws IOException {
        this.ensureCapacity((src.length << 1) + 128);
        int count = this.count;
        this.buf[count++] = 34;
        for (byte b : src) {
            count += JSONUnsafe.putInt(this.buf, count, HEX_DIGITS_INT32[b & 0xFF]);
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public final void writeTo(Writer writer) throws IOException {
        writer.write(this.buf, 0, this.count);
        writer.flush();
    }

    void clearCache() {
        if (this.bufCache != null) {
            if (this.buf.length <= MAX_CACHE_BUFFER_SIZE) {
                this.bufCache.cacheChars = this.buf;
            }
            this.bufCache.inUse = false;
            this.bufCache = null;
        }
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    void reset() {
        this.clear();
        this.clearCache();
        this.buf = EMPTY_BUF;
    }

    static {
        for (int i = 0; i < CACHE_COUNT; ++i) {
            BufCache bufCache = new BufCache();
            bufCache.index = i;
            if (i < AVAILABLE_PROCESSORS) {
                bufCache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
            JSONCharArrayWriter.CHAR_BUF_CACHES[i] = bufCache;
        }
    }

    static class IgnoreEscapeWriter
    extends JSONCharArrayWriter {
        IgnoreEscapeWriter() {
        }

        @Override
        public void writeJSONChars(char[] chars) throws IOException {
            int len = chars.length;
            this.ensureCapacity(len + 130);
            int count = this.count;
            this.buf[count++] = 34;
            System.arraycopy(chars, 0, this.buf, count, len);
            count += len;
            this.buf[count++] = 34;
            this.count = count;
        }

        @Override
        public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
            int len = bytes.length;
            this.ensureCapacity(len + 130);
            int count = this.count;
            this.buf[count++] = 34;
            value.getChars(0, len, this.buf, count);
            count += len;
            this.buf[count++] = 34;
            this.count = count;
        }
    }

    private static class BufCache {
        char[] cacheChars;
        boolean inUse;
        int index;

        private BufCache() {
        }
    }
}

