/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONNode;
import io.github.wycst.wast.json.JSONNodeCollector;
import io.github.wycst.wast.json.JSONNodeContext;
import io.github.wycst.wast.json.JSONNodePathCollector;
import io.github.wycst.wast.json.JSONNodePathCtx;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class JSONNodePath {
    static final JSONNodePath ALL = JSONNodePath.collectors(JSONNodePathCollector.any().recursive(true));
    private int depth;
    JSONNodePathCollector head;
    JSONNodePathCollector tail;
    boolean supportedExtract;
    boolean greedy = true;

    private JSONNodePath() {
    }

    JSONNodePath(JSONNodePathCollector head, JSONNodePathCollector tail, int depth) {
        this.head = head;
        this.tail = tail;
        this.depth = depth;
    }

    JSONNodePath supportedExtract(boolean supportedExtract) {
        this.supportedExtract = supportedExtract;
        return this;
    }

    public JSONNodePath self() {
        return this;
    }

    public JSONNodePath greedy(boolean greedy) {
        this.greedy = greedy;
        return this;
    }

    public List<JSONNode> collect(JSONNode parentNode) {
        ArrayList<JSONNode> results = new ArrayList<JSONNode>();
        this.head.collect(parentNode, results, JSONNodeCollector.DEFAULT, this.newCollectCtx());
        return results;
    }

    public <T> List<T> collect(JSONNode parentNode, JSONNodeCollector<T> collector) {
        ArrayList results = new ArrayList();
        this.head.collect(parentNode, results, collector, this.newCollectCtx());
        return results;
    }

    public void collect(JSONNode parentNode, Collection<JSONNode> results) {
        this.head.collect(parentNode, results, JSONNodeCollector.DEFAULT, this.newCollectCtx());
    }

    public <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector) {
        collector.getClass();
        this.head.collect(parentNode, results, collector, this.newCollectCtx());
    }

    JSONNodePathCtx newCollectCtx() {
        return new JSONNodePathCtx(this.greedy);
    }

    public static JSONNodePath create() {
        return new JSONNodePath();
    }

    /*
     * Unable to fully structure code
     */
    public static JSONNodePath parse(String xpath) {
        if (xpath == null || (len = (xpath = xpath.trim()).length()) == 0) {
            return null;
        }
        offset = 0;
        result = JSONNodePath.create();
        chars = UnsafeHelper.getChars(xpath);
        try {
            dn = 0;
            beginChar = chars[0];
            if (beginChar != '/') {
                ++dn;
            }
            while (offset < len) {
                block37: {
                    block38: {
                        while ((ch = chars[offset]) == '/') {
                            ++dn;
                            if (++offset != len) continue;
                            return result;
                        }
                        recursive = dn > 1;
                        begin = offset;
                        if (ch != '\'') break block38;
                        while (chars[++offset] != '\'') {
                        }
                        path = new String(chars, begin + 1, offset - begin - 1);
                        pathCollector = JSONNodePathCollector.exact((Serializable)path).recursive(recursive);
                        result.next(pathCollector);
                        if (++offset == len) {
                            return result;
                        }
                        ch = chars[offset];
                        break block37;
                    }
                    if (ch == '[') {
                        block36: {
                            try {
                                parseContext = new JSONNodeContext();
                                parseContext.toIndex = len;
                                values = JSONTypeDeserializer.INTEGER_ARRAY.deserialize(chars, offset, parseContext);
                                if (values.length == 1) {
                                    pathCollector = JSONNodePathCollector.exact(values[0]);
                                } else {
                                    if (values.length == 0) {
                                        errorMsg = JSONGeneral.createErrorContextText(chars, offset);
                                        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorMsg + "', empty array");
                                    }
                                    pathCollector = JSONNodePathCollector.indexs(values);
                                }
                                result.next(pathCollector.recursive(recursive));
                                offset = parseContext.endIndex + 1;
                                if (offset == len) {
                                    return result;
                                }
                                ch = chars[offset];
                                if (ch != '[' && ch != '/') break block36;
                                break block37;
                            }
                            catch (Throwable parseContext) {
                                // empty catch block
                            }
                        }
                        errorMsg = JSONGeneral.createErrorContextText(chars, offset);
                        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorMsg + "', error index array");
                    }
                    begin = offset++;
                    beginChar = ch;
                    v0 = isNegative = ch == '-';
                    if (!isNegative && !NumberUtils.isDigit(ch)) ** GOTO lbl-1000
                    val = 0;
                    if (!isNegative) {
                        val = ch - 48;
                    }
                    while (offset < len && NumberUtils.isDigit(ch = chars[offset])) {
                        ++offset;
                        val = val * 10 + ch - 48;
                    }
                    digitCnt = offset - begin;
                    if (digitCnt >= 7) ** GOTO lbl-1000
                    down = false;
                    range = false;
                    up = ch == '+';
                    if (up || (down = ch == '-') || (range = ch == '~')) {
                        ++offset;
                    }
                    if (range) {
                        from = isNegative != false ? -val : val;
                        to = 0;
                        v1 = isNegative = chars[offset] == '-';
                        if (isNegative) {
                            ++offset;
                        }
                        while (offset < len && NumberUtils.isDigit(ch = chars[offset])) {
                            ++offset;
                            to = to * 10 + ch - 48;
                        }
                        pathCollector = JSONNodePathCollector.range(from, isNegative != false ? -to : to);
                        result.next(pathCollector.recursive(recursive));
                        if (offset == len) {
                            return result;
                        }
                        if (ch != '[' && ch != '/') {
                            errorMsg = JSONGeneral.createErrorContextText(chars, offset);
                            throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorMsg + "', error range ");
                        }
                    } else {
                        v2 = isEnd = offset == len;
                        if (isEnd || (ch = chars[offset]) == '[' || ch == '/') {
                            pathCollector = up != false ? JSONNodePathCollector.ge(isNegative != false ? -val : val) : (down != false ? JSONNodePathCollector.le(isNegative != false ? -val : val) : JSONNodePathCollector.exact(Integer.valueOf(isNegative != false ? -val : val)));
                            result.next(pathCollector.recursive(recursive));
                            if (isEnd) {
                                return result;
                            }
                        } else lbl-1000:
                        // 4 sources

                        {
                            while (offset < len && (ch = chars[offset]) != '[' && ch != '/') {
                                ++offset;
                            }
                            pathLen = offset - begin;
                            endChar = chars[offset - 1];
                            pathCollector = beginChar == '*' ? (pathLen == 1 ? JSONNodePathCollector.any() : (endChar == '*' ? JSONNodePathCollector.contains((Serializable)new String(chars, begin + 1, pathLen - 2)) : JSONNodePathCollector.suffix((Serializable)new String(chars, begin + 1, pathLen - 1)))) : (beginChar == '^' ? JSONNodePathCollector.regular(new String(chars, begin + 1, pathLen - 1)) : (endChar == '*' ? JSONNodePathCollector.prefix((Serializable)new String(chars, begin, pathLen - 1)) : JSONNodePathCollector.exact((Serializable)JSONNodeContext.getString(chars, begin, pathLen))));
                            result.next(pathCollector.recursive(recursive));
                            if (offset == len) {
                                return result;
                            }
                        }
                    }
                }
                if (ch == '[') {
                    try {
                        parser = Expression.find(xpath, ++offset);
                        offset = parser.findIndex();
                        pathCollector.condition(parser);
                        result.supportedExtract(false);
                        if (offset == len || (ch = xpath.charAt(offset++)) != ']') {
                            errorMsg = JSONGeneral.createErrorContextText(chars, offset);
                            throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorMsg + "', unexpected '" + ch + "', expected end ']'  error expression, ");
                        }
                        if (offset == len) {
                            return result;
                        }
                        ch = chars[offset];
                    }
                    catch (RuntimeException e) {
                        if (e instanceof JSONException) {
                            throw e;
                        }
                        errorMsg = JSONGeneral.createErrorContextText(chars, offset);
                        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorMsg + "', error expression", e);
                    }
                }
                if (ch != '/') {
                    throw new JSONException("Syntax error, at pos " + offset + ", unexpected '" + ch + "', expected '/'.");
                }
                ++offset;
                dn = 1;
            }
        }
        catch (Throwable e) {
            throw e instanceof JSONException != false ? (JSONException)e : new JSONException("not supported path '" + xpath + "'");
        }
        return result;
    }

    public static JSONNodePath collectors(JSONNodePathCollector ... collectors) {
        JSONNodePathCollector prev = null;
        JSONNodePathCollector head = null;
        JSONNodePathCollector tail = null;
        boolean supportedExtract = true;
        for (JSONNodePathCollector pathCollector : collectors) {
            if (!pathCollector.isSupportedExtract()) {
                supportedExtract = false;
            }
            if (prev == null) {
                tail = prev = pathCollector.clone();
                head = prev;
                continue;
            }
            pathCollector.chainable(prev);
            tail = prev = prev.next;
        }
        return new JSONNodePath(head, tail, collectors.length).supportedExtract(supportedExtract);
    }

    public static JSONNodePath paths(Serializable ... paths) {
        JSONNodePathCollector prev = null;
        JSONNodePathCollector head = null;
        JSONNodePathCollector tail = null;
        for (Serializable path : paths) {
            JSONNodePathCollector pathFragment = JSONNodePathCollector.exact(path);
            if (prev == null) {
                tail = prev = pathFragment;
                head = prev;
                continue;
            }
            prev.next = pathFragment;
            tail = prev = pathFragment;
        }
        return new JSONNodePath(head, tail, paths.length).supportedExtract(true);
    }

    public JSONNodePath nextPaths(Serializable ... paths) {
        JSONNodePath nextNodePath = JSONNodePath.paths(paths);
        if (this.head == null) {
            this.head = nextNodePath.head;
            this.tail = nextNodePath.tail;
        } else {
            this.tail.next = nextNodePath.head;
            this.tail = nextNodePath.tail;
        }
        this.depth += paths.length;
        return this;
    }

    public JSONNodePath any() {
        return this.any(false);
    }

    public JSONNodePath any(boolean recursive) {
        return this.next(JSONNodePathCollector.any().recursive(recursive));
    }

    public JSONNodePath exact(Serializable path) {
        return this.exact(path, false);
    }

    public JSONNodePath exact(Serializable path, boolean recursive) {
        return this.next(JSONNodePathCollector.exact(path).recursive(recursive));
    }

    public JSONNodePath prefix(String path) {
        return this.prefix(path, false);
    }

    public JSONNodePath prefix(String path, boolean recursive) {
        return this.next(JSONNodePathCollector.prefix((Serializable)((Object)path)).recursive(recursive));
    }

    public JSONNodePath suffix(String path) {
        return this.suffix(path, false);
    }

    public JSONNodePath suffix(String path, boolean recursive) {
        return this.next(JSONNodePathCollector.suffix((Serializable)((Object)path)).recursive(recursive));
    }

    public JSONNodePath contains(String path) {
        return this.contains(path, false);
    }

    public JSONNodePath contains(String path, boolean recursive) {
        return this.next(JSONNodePathCollector.contains((Serializable)((Object)path)).recursive(recursive));
    }

    public JSONNodePath regular(String path) {
        return this.regular(path, false);
    }

    public JSONNodePath regular(String str, boolean recursive) {
        return this.next(JSONNodePathCollector.regular(str).recursive(recursive));
    }

    public JSONNodePath ge(int index) {
        return this.ge(index, false);
    }

    public JSONNodePath ge(int index, boolean recursive) {
        return this.next(JSONNodePathCollector.ge(index).recursive(recursive));
    }

    public JSONNodePath le(int index) {
        return this.le(index, false);
    }

    public JSONNodePath le(int index, boolean recursive) {
        return this.next(JSONNodePathCollector.le(index).recursive(recursive));
    }

    public JSONNodePath range(int from, int to) {
        return this.range(from, to, false);
    }

    public JSONNodePath range(int from, int to, boolean recursive) {
        return this.next(JSONNodePathCollector.range(from, to).recursive(recursive));
    }

    public JSONNodePath indexs(Integer ... indexs) {
        return this.indexs(false, indexs);
    }

    public JSONNodePath indexs(boolean recursive, Integer ... indexs) {
        return this.next(JSONNodePathCollector.indexs(indexs).recursive(recursive));
    }

    public JSONNodePath next(JSONNodePathCollector next) {
        boolean supportedExtract = next.isSupportedExtract();
        if (this.head == null) {
            this.head = this.tail = next.self();
            this.supportedExtract = supportedExtract;
        } else {
            this.tail = this.tail.next = next.self();
            if (!supportedExtract) {
                this.supportedExtract = false;
            }
        }
        ++this.depth;
        return this;
    }

    public JSONNodePath resetPaths() {
        this.tail = null;
        this.head = null;
        this.supportedExtract = false;
        this.depth = 0;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        JSONNodePathCollector value = this.head;
        while (value != null) {
            builder.append(value);
            value = value.next;
        }
        return builder.toString();
    }
}

