/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.annotations.JsonSerialize;
import io.github.wycst.wast.json.custom.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class JSONPojoFieldSerializer
extends JSONTypeSerializer {
    final GetterInfo getterInfo;
    final JsonProperty jsonProperty;
    final String name;
    final ReflectConsts.ClassCategory classCategory;
    JSONTypeSerializer serializer;
    private char[] fieldNameTokenChars;
    private String fieldNameToken;
    private int fieldNameTokenOffset;
    private long[] fieldNameCharLongs;
    private long[] fieldNameByteLongs;
    private boolean flag;
    private static final Map<Class<? extends JsonSerializer>, JsonSerializer> customSerializers = new HashMap<Class<? extends JsonSerializer>, JsonSerializer>();

    JSONPojoFieldSerializer(GetterInfo getterInfo, String name) {
        JsonProperty jsonProperty;
        this.getterInfo = getterInfo;
        this.classCategory = getterInfo.getClassCategory();
        this.name = name;
        this.jsonProperty = jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
        this.setFieldNameToken();
    }

    void initSerializer() {
        if (this.flag) {
            return;
        }
        if (this.serializer == null) {
            this.flag = true;
            this.serializer = this.createSerializer();
        }
    }

    private JSONTypeSerializer createSerializer() {
        Class<?> valueClass;
        GenericParameterizedType valueType;
        Class<?> returnType;
        JsonSerialize jsonSerialize = (JsonSerialize)this.getterInfo.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null) {
            Class<? extends JsonSerializer> jsonSerializerClass = jsonSerialize.value();
            try {
                if (jsonSerialize.singleton()) {
                    JsonSerializer jsonSerializer = customSerializers.get(jsonSerializerClass);
                    if (jsonSerializer == null) {
                        jsonSerializer = jsonSerializerClass.newInstance();
                        customSerializers.put(jsonSerializerClass, jsonSerializer);
                    }
                    return jsonSerializer;
                }
                return jsonSerializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((returnType = this.getterInfo.getReturnType()) == String.class) {
            return CHAR_SEQUENCE_STRING;
        }
        if (this.classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return JSONTypeSerializer.getTypeSerializer(returnType);
        }
        GenericParameterizedType genericParameterizedType = this.getterInfo.getGenericParameterizedType();
        if (this.classCategory == ReflectConsts.ClassCategory.CollectionCategory && genericParameterizedType != null && (valueType = genericParameterizedType.getValueType()) != null && Modifier.isFinal((valueClass = valueType.getActualType()).getModifiers())) {
            return JSONTypeSerializer.createCollectionSerializer(valueClass);
        }
        return JSONTypeSerializer.getFieldTypeSerializer(this.classCategory, returnType, this.jsonProperty);
    }

    public boolean isStringCollection() {
        if (this.classCategory == ReflectConsts.ClassCategory.CollectionCategory) {
            GenericParameterizedType parameterizedType = this.getterInfo.getGenericParameterizedType();
            return parameterizedType != null && parameterizedType.getValueType() == GenericParameterizedType.StringType;
        }
        return false;
    }

    private void setFieldNameToken() {
        int len = this.name.length();
        this.fieldNameTokenChars = new char[len + 7];
        int i = 0;
        this.fieldNameTokenChars[i++] = 34;
        this.name.getChars(0, len, this.fieldNameTokenChars, i);
        this.fieldNameTokenChars[len + 1] = 34;
        this.fieldNameTokenChars[len + 2] = 58;
        this.fieldNameTokenOffset = len + 3;
        this.fieldNameTokenChars[len + 3] = 110;
        this.fieldNameTokenChars[len + 4] = 117;
        this.fieldNameTokenChars[len + 5] = 108;
        this.fieldNameTokenChars[len + 6] = 108;
        if (EnvUtils.JDK_9_PLUS) {
            this.fieldNameToken = new String(this.fieldNameTokenChars);
        }
        if (this.name.getBytes().length == len) {
            String stringForUnsafe = new String(this.fieldNameTokenChars, 0, this.fieldNameTokenOffset);
            this.fieldNameCharLongs = UnsafeHelper.getCharLongs(stringForUnsafe);
            this.fieldNameByteLongs = UnsafeHelper.getByteLongs(stringForUnsafe);
        }
    }

    void writeFieldNameAndColonTo(JSONWriter writer) throws IOException {
        if (this.fieldNameCharLongs != null) {
            writer.writeMemory(this.fieldNameCharLongs, this.fieldNameByteLongs, this.fieldNameTokenOffset);
        } else if (this.fieldNameToken != null) {
            writer.write(this.fieldNameToken, 0, this.fieldNameTokenOffset);
        } else {
            writer.writeShortChars(this.fieldNameTokenChars, 0, this.fieldNameTokenOffset);
        }
    }

    void writeJSONFieldNameWithNull(JSONWriter writer) throws IOException {
        if (this.fieldNameToken != null) {
            writer.write(this.fieldNameToken, 0, this.fieldNameTokenChars.length);
        } else {
            writer.writeShortChars(this.fieldNameTokenChars, 0, this.fieldNameTokenChars.length);
        }
    }

    public JSONTypeSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
    }

    public String getName() {
        return this.name;
    }

    public JsonProperty getJsonProperty() {
        return this.jsonProperty;
    }
}

