/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.net.URI;
import java.net.URL;
import java.util.UUID;

final class JSONTypeExtensionDesr {
    JSONTypeExtensionDesr() {
    }

    static void initExtens() {
        JSONTypeDeserializer.putTypeDeserializer(new UUIDImpl(), UUID.class);
        JSONTypeDeserializer.putTypeDeserializer(new URLImpl(), URL.class);
        JSONTypeDeserializer.putTypeDeserializer(new URIImpl(), URI.class);
    }

    static final class URIImpl
    extends JSONTypeDeserializer {
        URIImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) throws Exception {
            return new URI(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            String urlString = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            return new URI(urlString);
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            String urlString = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, bytes, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            return new URI(urlString);
        }
    }

    static final class URLImpl
    extends JSONTypeDeserializer {
        URLImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) throws Exception {
            return new URL(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            String urlString = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            return new URL(urlString);
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            String urlString = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, bytes, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            return new URL(urlString);
        }
    }

    static final class UUIDImpl
    extends JSONTypeDeserializer {
        UUIDImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return UUID.fromString(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            int offset = fromIndex + 1;
            if (beginChar == '\"' || beginChar == '\'') {
                if (buf[offset] == beginChar) {
                    parseContext.endIndex = offset;
                    return null;
                }
                try {
                    int endIndex;
                    long mh = UUIDImpl.hex8ToLong(buf, offset);
                    long ml = UUIDImpl.hex4ToLong(buf, offset + 9) << 16 | UUIDImpl.hex4ToLong(buf, offset + 14);
                    long lh = UUIDImpl.hex4ToLong(buf, offset + 19) << 16 | UUIDImpl.hex4ToLong(buf, offset + 24);
                    long ll = UUIDImpl.hex8ToLong(buf, offset + 28);
                    if ((mh | ml | lh | ll) > -1L && buf[offset + 8] == '-' && buf[offset + 13] == '-' && buf[offset + 18] == '-' && buf[offset + 23] == '-' && buf[endIndex = offset + 36] == beginChar) {
                        parseContext.endIndex = endIndex;
                        return new UUID(mh << 32 | ml, lh << 32 | ll);
                    }
                }
                catch (Throwable mh) {}
            } else if (beginChar == 'n') {
                return UUIDImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = UUIDImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', illegal uuid characters");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            int offset = fromIndex + 1;
            if (beginByte == 34 || beginByte == 39) {
                if (buf[offset] == beginByte) {
                    parseContext.endIndex = offset;
                    return null;
                }
                try {
                    int endIndex;
                    long mh = UUIDImpl.hex8ToLong(buf, offset);
                    long ml = UUIDImpl.hex4ToLong(buf, offset + 9) << 16 | UUIDImpl.hex4ToLong(buf, offset + 14);
                    long lh = UUIDImpl.hex4ToLong(buf, offset + 19) << 16 | UUIDImpl.hex4ToLong(buf, offset + 24);
                    long ll = UUIDImpl.hex8ToLong(buf, offset + 28);
                    if ((mh | ml | lh | ll) > -1L && buf[offset + 8] == 45 && buf[offset + 13] == 45 && buf[offset + 18] == 45 && buf[offset + 23] == 45 && buf[endIndex = offset + 36] == beginByte) {
                        parseContext.endIndex = endIndex;
                        return new UUID(mh << 32 | ml, lh << 32 | ll);
                    }
                }
                catch (Throwable mh) {}
            } else if (beginByte == 110) {
                return UUIDImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = UUIDImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', illegal uuid characters");
        }
    }
}

