/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.log.TextFormatter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;

public class FileHandlerHolder {
    private final String handlerName;
    private final FileHandler fileHandler;
    private Level level;
    private String packages;

    FileHandlerHolder(String handlerName, String pattern, int limit, int count) throws IOException {
        this(handlerName, pattern, limit, count, true);
    }

    FileHandlerHolder(String handlerName, String pattern, int limit, int count, boolean append) throws IOException {
        this.handlerName = handlerName;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u65e5\u5fd7\u6587\u4ef6\u7684\u540d\u79f0\u8868\u8fbe\u5f0f");
        }
        this.fileHandler = new FileHandler(pattern, limit, count, append);
        this.fileHandler.setFormatter(new TextFormatter());
    }

    public void setLevel(Level level) {
        this.level = level;
        this.fileHandler.setLevel(level);
    }

    public Level getLevel() {
        return this.level;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public String getPackages() {
        return this.packages;
    }

    public void clear() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }
}

