/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.yaml.YamlGeneral;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class YamlLine
extends YamlGeneral {
    protected int lineNum;
    protected int indent;
    protected char[] content;
    protected String key;
    protected String value;
    protected int valueType;
    protected Object typeOfValue;
    protected int level;
    protected boolean leaf;
    protected boolean textBlock;
    public int blockType;
    protected boolean arrayToken;
    protected String anchorKey;
    public String referenceKey;
    protected int arrayIndex = -1;

    YamlLine() {
    }

    protected void writeTypeToken(Writer writer) throws IOException {
        if (this.valueType > 0) {
            switch (this.valueType) {
                case 1: {
                    break;
                }
                case 2: {
                    writer.write("!!float ");
                    break;
                }
                case 3: {
                    writer.write("!!int ");
                    break;
                }
                case 4: {
                    writer.write("!!bool ");
                    break;
                }
                case 5: {
                    writer.write("!!binary ");
                    break;
                }
                case 6: {
                    writer.write("!!timestamp ");
                    break;
                }
                case 7: {
                    writer.write("!!set ");
                    break;
                }
                case 8: {
                    writer.write("!!omap ");
                    break;
                }
                case 9: {
                    writer.write("!!seq ");
                    break;
                }
                default: {
                    writer.write("!!map ");
                }
            }
        }
    }

    protected void writeBlockToken(Writer writer) throws IOException {
        writer.write("|");
        if (this.blockType == 1) {
            writer.write("+");
        } else if (this.blockType == 2) {
            writer.write("-");
        }
    }

    protected void writeArrayToken(Writer writer) throws IOException {
        if (this.arrayIndex > -1) {
            writer.write("- ");
        }
    }

    protected void writeNewLine(Writer writer) throws IOException {
        writer.write(IS_WINDOW_OS ? "\r\n" : "\n");
    }

    protected void writeIndent(Writer writer) throws IOException {
        this.writeIndent(writer, this.indent);
    }

    protected void writeIndent(Writer writer, int indent) throws IOException {
        char[] indents = new char[indent];
        Arrays.fill(indents, ' ');
        writer.write(indents);
    }
}

