/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.StorageManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class BinaryUploader {
    public static State save(MultipartFile upfile, HttpServletRequest request, Map<String, Object> conf) {
        if (!BinaryUploader.isMultipart(request)) {
            return new BaseState(false, 5);
        }
        try {
            if (upfile == null) {
                return new BaseState(false, 7);
            }
            Object savePath = (String)conf.get("savePath");
            String originFileName = upfile.getOriginalFilename();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = (String)savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            if ((savePath = PathFormat.parse((String)savePath, originFileName)) != null && (((String)savePath).contains("../") || ((String)savePath).contains("..\\"))) {
                return new BaseState(false, 302);
            }
            String physicalPath = (String)conf.get("rootPath") + (String)savePath;
            InputStream is = upfile.getInputStream();
            State storageState = StorageManager.saveFileByInputStream(is, physicalPath, maxSize);
            is.close();
            if (storageState.isSuccess()) {
                storageState.putInfo("url", PathFormat.format((String)savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            return storageState;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        catch (Exception e) {
            return new BaseState(false, 6);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return "POST".equalsIgnoreCase(request.getMethod()) && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }
}

