/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;

class HelidonCdiProvider
implements CDIProvider {
    private static final AtomicReference<CDI<Object>> CURRENT_CDI = new AtomicReference();

    HelidonCdiProvider() {
    }

    public CDI<Object> getCDI() {
        CDI<Object> cdi = CURRENT_CDI.get();
        if (null == cdi) {
            throw new IllegalStateException("There is no CDI instance available");
        }
        return cdi;
    }

    static void setCdi(CDI<Object> cdi) {
        CURRENT_CDI.set(cdi);
    }

    static void unset() {
        CURRENT_CDI.set(null);
    }
}

