/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=IntOrStringAdapter.class)
public class IntOrString {
    private final boolean isInt;
    private final String strValue;
    private final Integer intValue;

    public IntOrString(String value) {
        this.isInt = false;
        this.strValue = value;
        this.intValue = null;
    }

    public IntOrString(int value) {
        this.isInt = true;
        this.intValue = value;
        this.strValue = null;
    }

    public boolean isInteger() {
        return this.isInt;
    }

    public String getStrValue() {
        if (this.isInt) {
            throw new IllegalStateException("Not a string");
        }
        return this.strValue;
    }

    public Integer getIntValue() {
        if (!this.isInt) {
            throw new IllegalStateException("Not an integer");
        }
        return this.intValue;
    }

    public String toString() {
        return this.isInt ? String.valueOf(this.intValue) : this.strValue;
    }

    public static class IntOrStringAdapter
    extends TypeAdapter<IntOrString> {
        public void write(JsonWriter jsonWriter, IntOrString intOrString) throws IOException {
            if (intOrString.isInteger()) {
                jsonWriter.value((Number)intOrString.getIntValue());
            } else {
                jsonWriter.value(intOrString.getStrValue());
            }
        }

        public IntOrString read(JsonReader jsonReader) throws IOException {
            JsonToken nextToken = jsonReader.peek();
            if (nextToken == JsonToken.NUMBER) {
                return new IntOrString(jsonReader.nextInt());
            }
            if (nextToken == JsonToken.STRING) {
                return new IntOrString(jsonReader.nextString());
            }
            throw new IllegalStateException("Could not deserialize to IntOrString. Was " + nextToken);
        }
    }
}

