/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1KeyToPath;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Adapts a secret into a projected volume.  The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.")
public class V1SecretProjection {
    @SerializedName(value="items")
    private List<V1KeyToPath> items = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="optional")
    private Boolean optional = null;

    public V1SecretProjection items(List<V1KeyToPath> items) {
        this.items = items;
        return this;
    }

    public V1SecretProjection addItemsItem(V1KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    public List<V1KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<V1KeyToPath> items) {
        this.items = items;
    }

    public V1SecretProjection name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1SecretProjection optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="Specify whether the Secret or its key must be defined")
    public Boolean isOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecretProjection v1SecretProjection = (V1SecretProjection)o;
        return Objects.equals(this.items, v1SecretProjection.items) && Objects.equals(this.name, v1SecretProjection.name) && Objects.equals(this.optional, v1SecretProjection.optional);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecretProjection {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

