/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1alpha1AdmissionHookClientConfig;
import io.kubernetes.client.models.V1alpha1RuleWithOperations;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ExternalAdmissionHook describes an external admission webhook and the resources and operations it applies to.")
public class V1alpha1ExternalAdmissionHook {
    @SerializedName(value="clientConfig")
    private V1alpha1AdmissionHookClientConfig clientConfig = null;
    @SerializedName(value="failurePolicy")
    private String failurePolicy = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="rules")
    private List<V1alpha1RuleWithOperations> rules = null;

    public V1alpha1ExternalAdmissionHook clientConfig(V1alpha1AdmissionHookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    @ApiModelProperty(required=true, value="ClientConfig defines how to communicate with the hook. Required")
    public V1alpha1AdmissionHookClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(V1alpha1AdmissionHookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public V1alpha1ExternalAdmissionHook failurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return this;
    }

    @ApiModelProperty(value="FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.")
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public void setFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    public V1alpha1ExternalAdmissionHook name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the external admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha1ExternalAdmissionHook rules(List<V1alpha1RuleWithOperations> rules) {
        this.rules = rules;
        return this;
    }

    public V1alpha1ExternalAdmissionHook addRulesItem(V1alpha1RuleWithOperations rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1RuleWithOperations>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule.")
    public List<V1alpha1RuleWithOperations> getRules() {
        return this.rules;
    }

    public void setRules(List<V1alpha1RuleWithOperations> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ExternalAdmissionHook v1alpha1ExternalAdmissionHook = (V1alpha1ExternalAdmissionHook)o;
        return Objects.equals(this.clientConfig, v1alpha1ExternalAdmissionHook.clientConfig) && Objects.equals(this.failurePolicy, v1alpha1ExternalAdmissionHook.failurePolicy) && Objects.equals(this.name, v1alpha1ExternalAdmissionHook.name) && Objects.equals(this.rules, v1alpha1ExternalAdmissionHook.rules);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfig, this.failurePolicy, this.name, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ExternalAdmissionHook {\n");
        sb.append("    clientConfig: ").append(this.toIndentedString(this.clientConfig)).append("\n");
        sb.append("    failurePolicy: ").append(this.toIndentedString(this.failurePolicy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

