/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V1beta2Deployment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DeploymentList is a list of Deployments.")
public class V1beta2DeploymentList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="items")
    private List<V1beta2Deployment> items = new ArrayList<V1beta2Deployment>();
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ListMeta metadata = null;

    public V1beta2DeploymentList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta2DeploymentList items(List<V1beta2Deployment> items) {
        this.items = items;
        return this;
    }

    public V1beta2DeploymentList addItemsItem(V1beta2Deployment itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Items is the list of Deployments.")
    public List<V1beta2Deployment> getItems() {
        return this.items;
    }

    public void setItems(List<V1beta2Deployment> items) {
        this.items = items;
    }

    public V1beta2DeploymentList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta2DeploymentList metadata(V1ListMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard list metadata.")
    public V1ListMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ListMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeploymentList v1beta2DeploymentList = (V1beta2DeploymentList)o;
        return Objects.equals(this.apiVersion, v1beta2DeploymentList.apiVersion) && Objects.equals(this.items, v1beta2DeploymentList.items) && Objects.equals(this.kind, v1beta2DeploymentList.kind) && Objects.equals(this.metadata, v1beta2DeploymentList.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeploymentList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

