/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1EndpointConditions;
import io.kubernetes.client.openapi.models.V1EndpointHints;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1Endpoint {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<String> addresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private V1EndpointConditions conditions;
    public static final String SERIALIZED_NAME_DEPRECATED_TOPOLOGY = "deprecatedTopology";
    @SerializedName(value="deprecatedTopology")
    private Map<String, String> deprecatedTopology = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_HINTS = "hints";
    @SerializedName(value="hints")
    private V1EndpointHints hints;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_TARGET_REF = "targetRef";
    @SerializedName(value="targetRef")
    private V1ObjectReference targetRef;
    public static final String SERIALIZED_NAME_ZONE = "zone";
    @SerializedName(value="zone")
    private String zone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1Endpoint addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1Endpoint addAddressesItem(String addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nonnull
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public V1Endpoint conditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nullable
    public V1EndpointConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
    }

    public V1Endpoint deprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
        return this;
    }

    public V1Endpoint putDeprecatedTopologyItem(String key, String deprecatedTopologyItem) {
        if (this.deprecatedTopology == null) {
            this.deprecatedTopology = new HashMap<String, String>();
        }
        this.deprecatedTopology.put(key, deprecatedTopologyItem);
        return this;
    }

    @Nullable
    public Map<String, String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    public void setDeprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
    }

    public V1Endpoint hints(V1EndpointHints hints) {
        this.hints = hints;
        return this;
    }

    @Nullable
    public V1EndpointHints getHints() {
        return this.hints;
    }

    public void setHints(V1EndpointHints hints) {
        this.hints = hints;
    }

    public V1Endpoint hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1Endpoint nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1Endpoint targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public V1Endpoint zone(String zone) {
        this.zone = zone;
        return this;
    }

    @Nullable
    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Endpoint v1Endpoint = (V1Endpoint)o;
        return Objects.equals(this.addresses, v1Endpoint.addresses) && Objects.equals(this.conditions, v1Endpoint.conditions) && Objects.equals(this.deprecatedTopology, v1Endpoint.deprecatedTopology) && Objects.equals(this.hints, v1Endpoint.hints) && Objects.equals(this.hostname, v1Endpoint.hostname) && Objects.equals(this.nodeName, v1Endpoint.nodeName) && Objects.equals(this.targetRef, v1Endpoint.targetRef) && Objects.equals(this.zone, v1Endpoint.zone);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Endpoint {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    deprecatedTopology: ").append(this.toIndentedString(this.deprecatedTopology)).append("\n");
        sb.append("    hints: ").append(this.toIndentedString(this.hints)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("    zone: ").append(this.toIndentedString(this.zone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1Endpoint is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1Endpoint` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADDRESSES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESSES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull()) {
            V1EndpointConditions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONDITIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_HINTS) != null && !jsonObj.get(SERIALIZED_NAME_HINTS).isJsonNull()) {
            V1EndpointHints.validateJsonElement(jsonObj.get(SERIALIZED_NAME_HINTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_REF) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_REF).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TARGET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_ZONE) != null && !jsonObj.get(SERIALIZED_NAME_ZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `zone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ZONE).toString()));
        }
    }

    public static V1Endpoint fromJson(String jsonString) throws IOException {
        return (V1Endpoint)JSON.getGson().fromJson(jsonString, V1Endpoint.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED_TOPOLOGY);
        openapiFields.add(SERIALIZED_NAME_HINTS);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_TARGET_REF);
        openapiFields.add(SERIALIZED_NAME_ZONE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESSES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1Endpoint.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1Endpoint.class));
            return new TypeAdapter<V1Endpoint>(){

                public void write(JsonWriter out, V1Endpoint value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1Endpoint read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1Endpoint.validateJsonElement(jsonElement);
                    return (V1Endpoint)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

