/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.CountAtValue;
import io.micrometer.core.instrument.ValueAtPercentile;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class HistogramSnapshot {
    private static final ValueAtPercentile[] EMPTY_VALUES = new ValueAtPercentile[0];
    private static final CountAtValue[] EMPTY_COUNTS = new CountAtValue[0];
    private static final HistogramSnapshot EMPTY = new HistogramSnapshot(0L, 0.0, 0.0, null, null);
    private final long count;
    private final double total;
    private final double max;
    private final ValueAtPercentile[] percentileValues;
    private final CountAtValue[] histogramCounts;

    public static HistogramSnapshot of(long count, double total, double max, ValueAtPercentile[] percentileValues, CountAtValue[] histogramCounts) {
        return new HistogramSnapshot(count, total, max, percentileValues, histogramCounts);
    }

    public static HistogramSnapshot empty() {
        return EMPTY;
    }

    private HistogramSnapshot(long count, double total, double max, ValueAtPercentile[] percentileValues, CountAtValue[] histogramCounts) {
        this.count = count;
        this.total = total;
        this.max = max;
        this.percentileValues = percentileValues != null ? percentileValues : EMPTY_VALUES;
        this.histogramCounts = histogramCounts != null ? histogramCounts : EMPTY_COUNTS;
    }

    public long count() {
        return this.count;
    }

    public double total() {
        return this.total;
    }

    public double total(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.total, unit);
    }

    public double max() {
        return this.max;
    }

    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.max, unit);
    }

    public double mean() {
        return this.count == 0L ? 0.0 : this.total / (double)this.count;
    }

    public double mean(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.mean(), unit);
    }

    public ValueAtPercentile[] percentileValues() {
        return this.percentileValues;
    }

    public CountAtValue[] histogramCounts() {
        return this.histogramCounts;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("HistogramSnapshot{count=");
        buf.append(this.count);
        buf.append(", total=");
        buf.append(this.total);
        buf.append(", mean=");
        buf.append(this.mean());
        buf.append(", max=");
        buf.append(this.max);
        if (this.percentileValues.length > 0) {
            buf.append(", percentileValues=");
            buf.append(Arrays.toString(this.percentileValues));
        }
        if (this.histogramCounts.length > 0) {
            buf.append(", histogramCounts=");
            buf.append(Arrays.toString(this.histogramCounts));
        }
        buf.append('}');
        return buf.toString();
    }
}

