/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import javax.cache.Cache;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JCacheMetrics
implements MeterBinder {
    private ObjectName objectName;
    private final String name;
    private final Iterable<Tag> tags;

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return JCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new JCacheMetrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public JCacheMetrics(Cache<?, ?> cache, String name, Iterable<Tag> tags) {
        try {
            String cacheManagerUri = cache.getCacheManager().getURI().toString().replace(':', '.');
            this.objectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + cacheManagerUri + ",Cache=" + cache.getName());
        }
        catch (MalformedObjectNameException ignored) {
            throw new IllegalStateException("Cache name '" + cache.getName() + "' results in an invalid JMX name");
        }
        this.name = name;
        this.tags = Tags.concat(tags, "name", cache.getName());
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(this.name + ".requests", this.objectName, CacheStatistics.CacheHits::get).tags(this.tags).tags("result", "hit").description("The number of times cache lookup methods have returned a cached value").register(registry);
        Gauge.builder(this.name + ".requests", this.objectName, CacheStatistics.CacheMisses::get).tags(this.tags).tags("result", "miss").description("The number of times cache lookup methods have not returned a value").register(registry);
        Gauge.builder(this.name + ".puts", this.objectName, CacheStatistics.CachePuts::get).tags(this.tags).description("Cache puts").register(registry);
        Gauge.builder(this.name + ".removals", this.objectName, CacheStatistics.CacheRemovals::get).tags(this.tags).description("Cache removals").register(registry);
        Gauge.builder(this.name + ".evictions", this.objectName, CacheStatistics.CacheEvictions::get).tags(this.tags).description("Cache evictions").register(registry);
    }

    private static enum CacheStatistics {
        CacheHits,
        CacheHitPercentage,
        CacheMisses,
        CacheMissPercentage,
        CacheGets,
        CachePuts,
        CacheRemovals,
        CacheEvictions,
        AverageGetTime,
        AveragePutTime,
        AverageRemoveTime;


        public long get(ObjectName objectName) {
            try {
                ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
                System.out.println("There are " + mBeanServers.size() + " MBean servers");
                for (MBeanServer mBeanServer : mBeanServers) {
                    try {
                        Object attribute = mBeanServer.getAttribute(objectName, this.toString());
                        return (Long)attribute;
                    }
                    catch (AttributeNotFoundException | InstanceNotFoundException operationsException) {
                    }
                }
            }
            catch (MBeanException | ReflectionException ex) {
                throw new IllegalStateException(ex);
            }
            return 0L;
        }
    }
}

