/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.internal.TimedExecutor;
import io.micrometer.core.instrument.internal.TimedExecutorService;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecutorServiceMetrics
implements MeterBinder {
    private final ExecutorService executorService;
    private final String name;
    private final Iterable<Tag> tags;

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Iterable<Tag> tags) {
        if (executor instanceof ExecutorService) {
            return ExecutorServiceMetrics.monitor(registry, (ExecutorService)executor, name, tags);
        }
        return new TimedExecutor(registry, executor, name, tags);
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Iterable<Tag> tags) {
        new ExecutorServiceMetrics(executor, name, tags).bindTo(registry);
        return new TimedExecutorService(registry, executor, name, tags);
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public ExecutorServiceMetrics(ExecutorService executorService, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.executorService = executorService;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.executorService == null) {
            return;
        }
        String className = this.executorService.getClass().getName();
        if (this.executorService instanceof ThreadPoolExecutor) {
            this.monitor(registry, (ThreadPoolExecutor)this.executorService);
        } else if (className.equals("java.util.concurrent.Executors$DelegatedScheduledExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass()));
        } else if (className.equals("java.util.concurrent.Executors$FinalizableDelegatedExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass().getSuperclass()));
        } else if (this.executorService instanceof ForkJoinPool) {
            this.monitor(registry, (ForkJoinPool)this.executorService);
        }
    }

    private ThreadPoolExecutor unwrapThreadPoolExecutor(ExecutorService executor, Class<?> wrapper) {
        try {
            Field e = wrapper.getDeclaredField("e");
            e.setAccessible(true);
            return (ThreadPoolExecutor)e.get(this.executorService);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private void monitor(MeterRegistry registry, ThreadPoolExecutor tp) {
        if (tp == null) {
            return;
        }
        FunctionCounter.builder(this.name + ".completed", tp, ThreadPoolExecutor::getCompletedTaskCount).tags(this.tags).description("The approximate total number of tasks that have completed execution").register(registry);
        Gauge.builder(this.name + ".active", tp, ThreadPoolExecutor::getActiveCount).tags(this.tags).description("The approximate number of threads that are actively executing tasks").register(registry);
        Gauge.builder(this.name + ".queued", tp, tpRef -> tpRef.getQueue().size()).tags(this.tags).description("The approximate number of threads that are queued for execution").register(registry);
        Gauge.builder(this.name + ".pool", tp, ThreadPoolExecutor::getPoolSize).tags(this.tags).description("The current number of threads in the pool").register(registry);
    }

    private void monitor(MeterRegistry registry, ForkJoinPool fj) {
        FunctionCounter.builder(this.name + ".steals", fj, ForkJoinPool::getStealCount).tags(this.tags).description("Estimate of the total number of tasks stolen from one thread's work queue by another. The reported value underestimates the actual total number of steals when the pool is not quiescent").register(registry);
        Gauge.builder(this.name + ".queued", fj, ForkJoinPool::getQueuedTaskCount).tags(this.tags).description("An estimate of the total number of tasks currently held in queues by worker threads").register(registry);
        Gauge.builder(this.name + ".active", fj, ForkJoinPool::getActiveThreadCount).tags(this.tags).description("An estimate of the number of threads that are currently stealing or executing tasks").register(registry);
        Gauge.builder(this.name + ".running", fj, ForkJoinPool::getRunningThreadCount).tags(this.tags).description("An estimate of the number of worker threads that are not blocked waiting to join tasks or for other managed synchronization threads").register(registry);
    }
}

