/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.system;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;

public class ProcessorMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public ProcessorMetrics() {
        this(Collections.emptyList());
    }

    public ProcessorMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Runtime runtime = Runtime.getRuntime();
        Gauge.builder("system.cpu.count", runtime, Runtime::availableProcessors).tags(this.tags).description("The number of processors available to the Java virtual machine").register(registry);
        OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemBean != null && operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            Gauge.builder("system.load.average.1m", operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage).tags(this.tags).description("The sum of the number of runnable entities queued to available processors and the number of runnable entities running on the available processors averaged over a period of time").register(registry);
        }
    }
}

