/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;

class CompositeDistributionSummary
extends AbstractCompositeMeter<DistributionSummary>
implements DistributionSummary {
    private final HistogramConfig histogramConfig;

    CompositeDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        super(id);
        this.histogramConfig = histogramConfig;
    }

    @Override
    public void record(double amount) {
        this.forEachChild(ds -> ds.record(amount));
    }

    @Override
    public long count() {
        return ((DistributionSummary)this.firstChild()).count();
    }

    @Override
    public double totalAmount() {
        return ((DistributionSummary)this.firstChild()).totalAmount();
    }

    @Override
    public double max() {
        return ((DistributionSummary)this.firstChild()).max();
    }

    @Override
    public double histogramCountAtValue(long value) {
        return ((DistributionSummary)this.firstChild()).histogramCountAtValue(value);
    }

    @Override
    public double percentile(double percentile) {
        return ((DistributionSummary)this.firstChild()).percentile(percentile);
    }

    @Override
    public HistogramSnapshot takeSnapshot(boolean supportsAggregablePercentiles) {
        return ((DistributionSummary)this.firstChild()).takeSnapshot(supportsAggregablePercentiles);
    }

    @Override
    DistributionSummary newNoopMeter() {
        return new NoopDistributionSummary(this.getId());
    }

    @Override
    DistributionSummary registerNewMeter(MeterRegistry registry) {
        return DistributionSummary.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).publishPercentiles(this.histogramConfig.getPercentiles()).publishPercentileHistogram(this.histogramConfig.isPercentileHistogram()).maximumExpectedValue(this.histogramConfig.getMaximumExpectedValue()).minimumExpectedValue(this.histogramConfig.getMinimumExpectedValue()).histogramBufferLength(this.histogramConfig.getHistogramBufferLength()).histogramExpiry(this.histogramConfig.getHistogramExpiry()).sla(this.histogramConfig.getSlaBoundaries()).register(registry);
    }
}

