/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeCounter;
import io.micrometer.core.instrument.composite.CompositeCustomMeter;
import io.micrometer.core.instrument.composite.CompositeDistributionSummary;
import io.micrometer.core.instrument.composite.CompositeFunctionTimer;
import io.micrometer.core.instrument.composite.CompositeGauge;
import io.micrometer.core.instrument.composite.CompositeLongTaskTimer;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.composite.CompositeTimeGauge;
import io.micrometer.core.instrument.composite.CompositeTimer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CompositeMeterRegistry
extends MeterRegistry {
    private final Set<MeterRegistry> registries = ConcurrentHashMap.newKeySet();
    private final Set<MeterRegistry> unmodifiableRegistries = Collections.unmodifiableSet(this.registries);

    public CompositeMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public CompositeMeterRegistry(Clock clock) {
        super(clock);
        this.config().namingConvention(NamingConvention.identity);
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig) {
        CompositeTimer timer = new CompositeTimer(id, this.clock, histogramConfig);
        this.registries.forEach(timer::add);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        CompositeDistributionSummary ds = new CompositeDistributionSummary(id, histogramConfig);
        this.registries.forEach(ds::add);
        return ds;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        CompositeCounter counter = new CompositeCounter(id);
        this.registries.forEach(counter::add);
        return counter;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        CompositeLongTaskTimer longTaskTimer = new CompositeLongTaskTimer(id);
        this.registries.forEach(longTaskTimer::add);
        return longTaskTimer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        CompositeGauge<T> gauge = new CompositeGauge<T>(id, obj, f);
        this.registries.forEach(gauge::add);
        return gauge;
    }

    @Override
    protected <T> TimeGauge newTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        CompositeTimeGauge<T> gauge = new CompositeTimeGauge<T>(id, obj, fUnit, f);
        this.registries.forEach(gauge::add);
        return gauge;
    }

    @Override
    protected <T> Meter newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        CompositeFunctionTimer<T> ft = new CompositeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
        this.registries.forEach(ft::add);
        return ft;
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        CompositeCustomMeter meter = new CompositeCustomMeter(id, type, measurements);
        this.registries.forEach(meter::add);
    }

    public CompositeMeterRegistry add(MeterRegistry registry) {
        if (this.registries.add(registry)) {
            this.forEachMeter(m -> ((CompositeMeter)m).add(registry));
        }
        return this;
    }

    public CompositeMeterRegistry remove(MeterRegistry registry) {
        if (this.registries.remove(registry)) {
            this.forEachMeter(m -> ((CompositeMeter)m).remove(registry));
        }
        return this;
    }

    public Set<MeterRegistry> getRegistries() {
        return this.unmodifiableRegistries;
    }
}

