/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.config;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Incubating(since="1.0.0-rc.3")
public interface MeterFilter {
    default public MeterFilterReply accept(Meter.Id id) {
        return MeterFilterReply.NEUTRAL;
    }

    default public Meter.Id map(Meter.Id id) {
        return id;
    }

    default public HistogramConfig configure(Meter.Id id, HistogramConfig config) {
        return config;
    }

    public static MeterFilter commonTags(final Iterable<Tag> tags) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                ArrayList<Tag> allTags = new ArrayList<Tag>();
                id.getTags().forEach(allTags::add);
                tags.forEach(allTags::add);
                return new Meter.Id(id.getName(), allTags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter ignoreTags(final String ... tagKeys) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> tags = StreamSupport.stream(id.getTags().spliterator(), false).filter(t -> {
                    for (String tagKey : tagKeys) {
                        if (!t.getKey().equals(tagKey)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                return new Meter.Id(id.getName(), tags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter replaceTagValues(final String tagKey, final Function<String, String> replacement, final String ... exceptions) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                List<Tag> tags = StreamSupport.stream(id.getTags().spliterator(), false).map((? super T t) -> {
                    if (!t.getKey().equals(tagKey)) {
                        return t;
                    }
                    for (String exception : exceptions) {
                        if (!t.getValue().equals(exception)) continue;
                        return t;
                    }
                    return Tag.of(tagKey, (String)replacement.apply(t.getValue()));
                }).collect(Collectors.toList());
                return new Meter.Id(id.getName(), tags, id.getBaseUnit(), id.getDescription(), id.getType());
            }
        };
    }

    public static MeterFilter accept(final Predicate<Meter.Id> iff) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return iff.test(id) ? MeterFilterReply.ACCEPT : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter deny(final Predicate<Meter.Id> iff) {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                return iff.test(id) ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }
        };
    }

    public static MeterFilter denyNameStartsWith(String prefix) {
        return MeterFilter.deny(id -> id.getName().startsWith(prefix));
    }
}

