/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final StepDouble max;

    DropwizardTimer(Meter.Id id, Timer impl, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
        this.impl = impl;
        this.max = new StepDouble(clock, 60000L);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.max.getCurrent().add(Math.max((double)nanoAmount - this.max.getCurrent().doubleValue(), 0.0));
            this.totalTime.addAndGet(nanoAmount);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.get(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.max.poll(), unit);
    }
}

