/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.TimeWindowHistogramBase;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.DoubleRecorder;

@Incubating(since="1.0.0-rc.3")
public class TimeWindowHistogram
extends TimeWindowHistogramBase<DoubleRecorder, DoubleHistogram> {
    private final DoubleHistogram intervalHistogram = new DoubleHistogram(2);

    public TimeWindowHistogram(Clock clock, HistogramConfig histogramConfig) {
        super(clock, histogramConfig, DoubleRecorder.class);
    }

    @Override
    DoubleRecorder newBucket(HistogramConfig histogramConfig) {
        return new DoubleRecorder(2);
    }

    @Override
    void recordDouble(DoubleRecorder bucket, double value) {
        bucket.recordValue(value);
    }

    @Override
    void recordLong(DoubleRecorder bucket, long value) {
        bucket.recordValue((double)value);
    }

    @Override
    void resetBucket(DoubleRecorder bucket) {
        bucket.reset();
    }

    DoubleHistogram newAccumulatedHistogram(DoubleRecorder[] ringBuffer) {
        return new DoubleHistogram(2);
    }

    @Override
    void accumulate(DoubleRecorder sourceBucket, DoubleHistogram accumulatedHistogram) {
        sourceBucket.getIntervalHistogramInto(this.intervalHistogram);
        accumulatedHistogram.add(this.intervalHistogram);
    }

    @Override
    void resetAccumulatedHistogram(DoubleHistogram accumulatedHistogram) {
        accumulatedHistogram.reset();
    }

    @Override
    double valueAtPercentile(DoubleHistogram accumulatedHistogram, double percentile) {
        return accumulatedHistogram.getValueAtPercentile(percentile);
    }

    @Override
    double countAtValue(DoubleHistogram accumulatedHistogram, long value) {
        return accumulatedHistogram.getCountBetweenValues(0.0, (double)value);
    }
}

