/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.NoopHistogram;
import io.micrometer.core.instrument.histogram.TimeWindowHistogramBase;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;

@Incubating(since="1.0.0-rc.3")
public class TimeWindowLatencyHistogram
extends TimeWindowHistogramBase<LatencyStats, Histogram> {
    public TimeWindowLatencyHistogram(Clock clock, HistogramConfig histogramConfig) {
        super(clock, histogramConfig, LatencyStats.class);
    }

    @Override
    LatencyStats newBucket(HistogramConfig histogramConfig) {
        return new LatencyStats.Builder().lowestTrackableLatency(histogramConfig.getMinimumExpectedValue().longValue()).highestTrackableLatency(histogramConfig.getMaximumExpectedValue().longValue()).numberOfSignificantValueDigits(2).build();
    }

    @Override
    void recordLong(LatencyStats bucket, long value) {
        bucket.recordLatency(value);
    }

    @Override
    void recordDouble(LatencyStats bucket, double value) {
        bucket.recordLatency((long)value);
    }

    @Override
    void resetBucket(LatencyStats bucket) {
        bucket.getIntervalHistogramInto((Histogram)NoopHistogram.INSTANCE);
    }

    Histogram newAccumulatedHistogram(LatencyStats[] ringBuffer) {
        return ringBuffer[0].getIntervalHistogram();
    }

    @Override
    void accumulate(LatencyStats sourceBucket, Histogram accumulatedHistogram) {
        sourceBucket.addIntervalHistogramTo(accumulatedHistogram);
    }

    @Override
    void resetAccumulatedHistogram(Histogram accumulatedHistogram) {
        accumulatedHistogram.reset();
    }

    @Override
    double valueAtPercentile(Histogram accumulatedHistogram, double percentile) {
        return accumulatedHistogram.getValueAtPercentile(percentile);
    }

    @Override
    double countAtValue(Histogram accumulatedHistogram, long value) {
        return accumulatedHistogram.getCountBetweenValues(0L, value);
    }
}

