/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.simple.CumulativeCounter;
import io.micrometer.core.instrument.simple.CumulativeDistributionSummary;
import io.micrometer.core.instrument.simple.CumulativeTimer;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig config, Clock clock) {
        super(clock);
        this.config = config;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        AbstractDistributionSummary summary;
        HistogramConfig merged = histogramConfig.merge(HistogramConfig.builder().histogramExpiry(this.config.step()).build());
        switch (this.config.mode()) {
            case Cumulative: {
                summary = new CumulativeDistributionSummary(id, this.clock, merged);
                break;
            }
            default: {
                summary = new StepDistributionSummary(id, this.clock, merged, this.config.step().toMillis());
            }
        }
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, summary::percentile);
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), summary, (T s) -> s.histogramCountAtValue(bucket));
            }
        }
        return summary;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig) {
        AbstractTimer timer;
        HistogramConfig merged = histogramConfig.merge(HistogramConfig.builder().histogramExpiry(this.config.step()).build());
        switch (this.config.mode()) {
            case Cumulative: {
                timer = new CumulativeTimer(id, this.clock, merged);
                break;
            }
            default: {
                timer = new StepTimer(id, this.clock, merged, this.config.step().toMillis());
            }
        }
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, p -> timer.percentile((double)p, this.getBaseTimeUnit()));
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", this.percentileFormat.format(TimeUtils.nanosToUnit(bucket.longValue(), this.getBaseTimeUnit()))), timer, (T t) -> t.histogramCountAtValue(bucket));
            }
        }
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return new DefaultGauge<T>(id, obj, f);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case Cumulative: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

