/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class StepLong {
    private final Clock clock;
    private final long stepMillis;
    private volatile double previous = 0.0;
    private final LongAdder current = new LongAdder();
    private final AtomicLong lastInitPos;

    public StepLong(Clock clock, long stepMillis) {
        this.clock = clock;
        this.stepMillis = stepMillis;
        this.lastInitPos = new AtomicLong(clock.wallTime() / stepMillis);
    }

    private void rollCount(long now) {
        long stepTime = now / this.stepMillis;
        long lastInit = this.lastInitPos.get();
        if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
            double v = this.current.sumThenReset();
            this.previous = lastInit == stepTime - 1L ? v : 0.0;
        }
    }

    public LongAdder getCurrent() {
        return this.current;
    }

    public double poll() {
        this.rollCount(this.clock.wallTime());
        return this.previous;
    }
}

