/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;

public interface WavefrontConfig
extends StepRegistryConfig {
    public static final WavefrontConfig DEFAULT_PROXY = new WavefrontConfig(){

        public String get(String key) {
            return null;
        }

        @Override
        public String uri() {
            String v = this.get(this.prefix() + ".uri");
            return v == null ? "proxy://localhost:2878" : v;
        }
    };
    public static final WavefrontConfig DEFAULT_DIRECT = new WavefrontConfig(){

        public String get(String key) {
            return null;
        }

        @Override
        public String uri() {
            String v = this.get(this.prefix() + ".uri");
            return v == null ? "https://longboard.wavefront.com" : v;
        }
    };

    default public Duration step() {
        String v = this.get(this.prefix() + ".step");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public String prefix() {
        return "wavefront";
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        if (v == null) {
            throw new MissingRequiredConfigurationException("A uri is required to publish metrics to Wavefront");
        }
        return v;
    }

    default public String source() {
        String v = this.get(this.prefix() + ".source");
        if (v != null) {
            return v;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "unknown";
        }
    }

    @Nullable
    default public String apiToken() {
        String v = this.get(this.prefix() + ".apiToken");
        return v == null ? null : (v.trim().length() > 0 ? v : null);
    }

    @Nullable
    default public String globalPrefix() {
        return this.get(this.prefix() + ".globalPrefix");
    }
}

