/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Map;

@Internal
final class CustomizedMapSerializer<K, V>
implements CustomizableSerializer<Map<K, V>>,
SerializerRegistrar<Map<K, V>> {
    CustomizedMapSerializer() {
    }

    public ObjectSerializer<Map<K, V>> createSpecific(Serializer.EncoderContext context, Argument<? extends Map<K, V>> type) throws SerdeException {
        boolean hasGenerics;
        Object[] generics = type.getTypeParameters();
        boolean bl = hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length != 2;
        if (hasGenerics) {
            Object valueGeneric = generics[1];
            final Serializer valSerializer = context.findSerializer((Argument)valueGeneric).createSpecific(context, (Argument)valueGeneric);
            return new ObjectSerializer<Map<K, V>>((Argument)valueGeneric){
                final /* synthetic */ Argument val$valueGeneric;
                {
                    this.val$valueGeneric = argument;
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    Encoder objectEncoder = encoder.encodeObject(type);
                    this.serializeInto(objectEncoder, context, type, value);
                    objectEncoder.finishStructure();
                }

                public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    for (Object k : value.keySet()) {
                        CustomizedMapSerializer.this.encodeMapKey(context, encoder, k);
                        Object v = value.get(k);
                        if (v == null) {
                            encoder.encodeNull();
                            continue;
                        }
                        valSerializer.serialize(encoder, context, this.val$valueGeneric, v);
                    }
                }

                public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                    return CollectionUtils.isEmpty(value);
                }
            };
        }
        return new ObjectSerializer<Map<K, V>>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                Encoder childEncoder = encoder.encodeObject(type);
                this.serializeInto(childEncoder, context, type, value);
                childEncoder.finishStructure();
            }

            public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                for (Map.Entry entry : value.entrySet()) {
                    CustomizedMapSerializer.this.encodeMapKey(context, encoder, entry.getKey());
                    Object v = entry.getValue();
                    if (v == null) {
                        encoder.encodeNull();
                        continue;
                    }
                    Argument valueGeneric = Argument.of(v.getClass());
                    Serializer valSerializer = context.findSerializer(valueGeneric).createSpecific(context, valueGeneric);
                    valSerializer.serialize(encoder, context, valueGeneric, v);
                }
            }

            public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                return CollectionUtils.isEmpty(value);
            }
        };
    }

    private void encodeMapKey(Serializer.EncoderContext context, Encoder childEncoder, K k) throws IOException {
        if (k instanceof CharSequence) {
            childEncoder.encodeKey(k.toString());
        } else {
            try {
                String result = (String)context.getConversionService().convertRequired(k, Argument.STRING);
                childEncoder.encodeKey(result != null ? result : k.toString());
            }
            catch (ConversionErrorException e) {
                throw new SerdeException("Error converting Map key [" + k + "] to String: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Argument<Map<K, V>> getType() {
        return Argument.mapOf((Argument)Argument.ofTypeVariable(Object.class, (String)"K"), (Argument)Argument.ofTypeVariable(Object.class, (String)"V"));
    }
}

