/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;

@Internal
final class JsonValueSerializer<T>
implements ObjectSerializer<T> {
    private final SerBean.SerProperty<T, Object> jsonValue;

    JsonValueSerializer(SerBean.SerProperty<T, Object> jsonValue) {
        this.jsonValue = jsonValue;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        this.jsonValue.serializer.serialize(encoder, context, this.jsonValue.argument, this.jsonValue.get(value));
    }

    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        throw new SerdeException("Serializer for a value type: " + type + " doesn't support serializing into an existing object");
    }

    public boolean isEmpty(Serializer.EncoderContext context, T value) {
        return this.jsonValue.serializer.isEmpty(context, this.jsonValue.get(value));
    }

    public boolean isAbsent(Serializer.EncoderContext context, T value) {
        return this.jsonValue.serializer.isAbsent(context, this.jsonValue.get(value));
    }
}

