/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import java.util.Iterator;

final class JsonArrayNodeDecoder
extends JsonNodeDecoder {
    private final Iterator<JsonNode> iterator;
    private JsonNode peeked;

    JsonArrayNodeDecoder(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.iterator = node.values().iterator();
        this.skipValue();
    }

    public boolean hasNextArrayValue() {
        return this.peeked != null;
    }

    public String decodeKey() {
        throw new IllegalStateException("Arrays have no keys");
    }

    public void skipValue() {
        this.peeked = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    public void finishStructure(boolean consumeLeftElements) {
        if (!consumeLeftElements && this.peeked != null) {
            throw new IllegalStateException("Not all elements have been consumed yet");
        }
    }

    @Override
    protected JsonNode peekValue() {
        if (this.peeked == null) {
            throw new IllegalStateException("No more elements");
        }
        return this.peeked;
    }
}

