/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.Payload;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import jakarta.validation.valueextraction.Unwrapping;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
class DefaultConstraintDescriptor<T extends Annotation>
implements ConstraintDescriptor<T> {
    @NonNull
    private final Class<T> type;
    @Nullable
    private final String message;
    @Nullable
    private final String defaultMessage;
    private final Set<Class<?>> groups;
    private final Set<Class<? extends Payload>> payload;
    private final List<Class<? extends ConstraintValidator<T, ?>>> validatedBy;
    private final ConstraintTarget validationAppliesTo;
    private final AnnotationValue<T> annotationValue;
    private final AnnotationMetadata annotationMetadata;

    DefaultConstraintDescriptor(@NonNull Class<T> constraintType, @NonNull AnnotationValue<T> annotationValue, @NonNull AnnotationMetadata annotationMetadata) {
        this(constraintType, annotationValue.stringValue("message").orElse(null), annotationValue.getDefaultValues() == null ? null : (String)annotationValue.getDefaultValues().get("message"), Set.of(annotationValue.classValues("groups")), Set.of(annotationValue.classValues("payload")), List.of(annotationValue.classValues("$validatedBy")), annotationValue.enumValue("validationAppliesTo", ConstraintTarget.class).orElse(ConstraintTarget.IMPLICIT), annotationValue, annotationMetadata);
    }

    DefaultConstraintDescriptor(@NonNull Class<T> type, @Nullable String message, @Nullable String defaultMessage, @NonNull Set<Class<?>> groups, @NonNull Set<Class<? extends Payload>> payload, @NonNull List<Class<? extends ConstraintValidator<T, ?>>> validatedBy, @NonNull ConstraintTarget validationAppliesTo, @NonNull AnnotationValue<T> annotationValue, @NonNull AnnotationMetadata annotationMetadata) {
        this.type = type;
        this.message = message;
        this.defaultMessage = defaultMessage;
        this.groups = groups;
        this.payload = payload;
        this.validatedBy = validatedBy;
        this.validationAppliesTo = validationAppliesTo;
        this.annotationValue = annotationValue;
        this.annotationMetadata = annotationMetadata;
    }

    public AnnotationValue<T> getAnnotationValue() {
        return this.annotationValue;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getAnnotation() {
        return (T)this.annotationMetadata.synthesize(this.type);
    }

    public String getMessageTemplate() {
        if (this.message != null) {
            return this.message;
        }
        if (this.defaultMessage != null) {
            return this.defaultMessage;
        }
        return "{" + this.type.getName() + ".message}";
    }

    public Set<Class<?>> getGroups() {
        if (this.groups.isEmpty()) {
            return Set.of(Default.class);
        }
        return this.groups;
    }

    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    public ConstraintTarget getValidationAppliesTo() {
        return this.validationAppliesTo;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.validatedBy;
    }

    public Map<String, Object> getAttributes() {
        Map values = this.annotationValue.getValues();
        LinkedHashMap variables = CollectionUtils.newLinkedHashMap((int)values.size());
        for (Map.Entry entry : values.entrySet()) {
            variables.put(entry.getKey().toString(), entry.getValue());
        }
        if (this.annotationValue.getDefaultValues() != null) {
            Map defaultValues = this.annotationValue.getDefaultValues();
            for (Map.Entry entry : defaultValues.entrySet()) {
                Object v;
                String n = ((CharSequence)entry.getKey()).toString();
                if (variables.containsKey(n) || (v = entry.getValue()) == null) continue;
                variables.put(n, v);
            }
        }
        return variables;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.emptySet();
    }

    public boolean isReportAsSingleViolation() {
        return false;
    }

    public ValidateUnwrappedValue getValueUnwrapping() {
        boolean unwrap = this.payload.contains(Unwrapping.Unwrap.class);
        boolean skip = this.payload.contains(Unwrapping.Skip.class);
        if (unwrap && skip) {
            throw new ConstraintDeclarationException("Payload declared with both " + Unwrapping.Unwrap.class.getName() + " and " + Unwrapping.Skip.class);
        }
        if (unwrap) {
            return ValidateUnwrappedValue.UNWRAP;
        }
        if (skip) {
            return ValidateUnwrappedValue.SKIP;
        }
        return ValidateUnwrappedValue.DEFAULT;
    }

    public <U> U unwrap(Class<U> type) {
        throw new UnsupportedOperationException("Unwrapping unsupported");
    }
}

