/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.ConversionServiceAware;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.validation.validator.DefaultClockProvider;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.DefaultConstraintValidators;
import io.micronaut.validation.validator.constraints.DefaultInternalConstraintValidatorFactory;
import io.micronaut.validation.validator.constraints.InternalConstraintValidatorFactory;
import io.micronaut.validation.validator.extractors.DefaultValueExtractors;
import io.micronaut.validation.validator.extractors.ValueExtractorDefinition;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import io.micronaut.validation.validator.messages.DefaultMessageInterpolator;
import io.micronaut.validation.validator.messages.DefaultMessages;
import jakarta.inject.Inject;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.validator")
public class DefaultValidatorConfiguration
implements ValidatorConfiguration,
Toggleable,
ValidatorContext,
ConversionServiceAware {
    @Nullable
    private InternalConstraintValidatorFactory constraintValidatorFactory;
    @Nullable
    private ConstraintValidatorRegistry constraintValidatorRegistry;
    @Nullable
    private ValueExtractorRegistry valueExtractorRegistry;
    @Nullable
    private ClockProvider clockProvider;
    @Nullable
    private ClockProvider defaultClockProvider;
    @Nullable
    private TraversableResolver traversableResolver;
    @Nullable
    private TraversableResolver defaultTraversableResolver;
    @Nullable
    private MessageInterpolator defaultMessageInterpolator;
    @Nullable
    private MessageInterpolator messageInterpolator;
    @Nullable
    private ExecutionHandleLocator executionHandleLocator;
    private ConversionService conversionService = ConversionService.SHARED;
    private BeanIntrospector beanIntrospector = BeanIntrospector.SHARED;
    private boolean enabled = true;

    @Inject
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    @NonNull
    public ConstraintValidatorRegistry getConstraintValidatorRegistry() {
        if (this.constraintValidatorRegistry == null) {
            this.constraintValidatorRegistry = new DefaultConstraintValidators();
        }
        return this.constraintValidatorRegistry;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        if (this.constraintValidatorFactory == null) {
            this.constraintValidatorFactory = new DefaultInternalConstraintValidatorFactory(this.beanIntrospector, null);
        }
        return this.constraintValidatorFactory;
    }

    @Internal
    @Inject
    void setInternalConstraintValidatorFactory(InternalConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DefaultValidatorConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Inject
    public DefaultValidatorConfiguration setConstraintValidatorRegistry(@Nullable ConstraintValidatorRegistry constraintValidatorRegistry) {
        this.constraintValidatorRegistry = constraintValidatorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ValueExtractorRegistry getValueExtractorRegistry() {
        if (this.valueExtractorRegistry == null) {
            this.valueExtractorRegistry = new DefaultValueExtractors();
        }
        return this.valueExtractorRegistry;
    }

    @Inject
    public DefaultValidatorConfiguration setValueExtractorRegistry(@Nullable ValueExtractorRegistry valueExtractorRegistry) {
        this.valueExtractorRegistry = valueExtractorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ClockProvider getClockProvider() {
        if (this.clockProvider == null) {
            return this.getDefaultClockProvider();
        }
        return this.clockProvider;
    }

    @Override
    public ClockProvider getDefaultClockProvider() {
        if (this.defaultClockProvider == null) {
            this.defaultClockProvider = new DefaultClockProvider();
        }
        return this.defaultClockProvider;
    }

    @Inject
    public DefaultValidatorConfiguration setClockProvider(@Nullable ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    @Override
    @NonNull
    public TraversableResolver getDefaultTraversableResolver() {
        if (this.defaultTraversableResolver == null) {
            this.defaultTraversableResolver = new TraversableResolver(){

                public boolean isReachable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                    return true;
                }

                public boolean isCascadable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                    return true;
                }
            };
        }
        return this.defaultTraversableResolver;
    }

    @Override
    @NonNull
    public TraversableResolver getTraversableResolver() {
        if (this.traversableResolver == null) {
            return this.getDefaultTraversableResolver();
        }
        return this.traversableResolver;
    }

    @Inject
    public DefaultValidatorConfiguration setTraversableResolver(@Nullable TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    @Override
    @NonNull
    public MessageInterpolator getMessageInterpolator() {
        if (this.messageInterpolator == null) {
            return this.getDefaultMessageInterpolator();
        }
        return this.messageInterpolator;
    }

    @Override
    @NonNull
    public MessageInterpolator getDefaultMessageInterpolator() {
        if (this.defaultMessageInterpolator == null) {
            this.defaultMessageInterpolator = new DefaultMessageInterpolator((MessageSource)new DefaultMessages());
        }
        return this.defaultMessageInterpolator;
    }

    @Inject
    public DefaultValidatorConfiguration setMessageInterpolator(@Nullable MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    @Override
    @NonNull
    public ExecutionHandleLocator getExecutionHandleLocator() {
        if (this.executionHandleLocator == null) {
            this.executionHandleLocator = ExecutionHandleLocator.EMPTY;
        }
        return this.executionHandleLocator;
    }

    @Inject
    public DefaultValidatorConfiguration setExecutionHandleLocator(final @Nullable BeanContext beanContext) {
        this.executionHandleLocator = new ExecutionHandleLocator(){

            public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class<?> ... arguments) {
                Optional foundMethod;
                if (beanType == null) {
                    return Optional.empty();
                }
                Collection definitions = beanContext.getBeanDefinitions(beanType);
                if (definitions.isEmpty()) {
                    return Optional.empty();
                }
                Optional<BeanDefinition> optionalBeanDefinition = definitions.stream().filter(bd -> bd.getBeanType().equals(beanType)).findFirst();
                if (optionalBeanDefinition.isPresent() && (foundMethod = optionalBeanDefinition.get().findMethod(method, (Class[])arguments)).isPresent()) {
                    return foundMethod;
                }
                BeanDefinition beanDefinition = (BeanDefinition)definitions.iterator().next();
                Optional foundMethod2 = beanDefinition.findMethod(method, (Class[])arguments);
                if (foundMethod2.isPresent()) {
                    return foundMethod2;
                }
                return beanDefinition.findPossibleMethods(method).findFirst();
            }
        };
        return this;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        throw new UnsupportedOperationException("Method constraintValidatorFactory(..) not supported");
    }

    public ValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        throw new UnsupportedOperationException("Method parameterNameProvider(..) not supported");
    }

    public ValidatorContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    public ValidatorContext addValueExtractor(ValueExtractor<?> extractor) {
        ArrayList<AnnotatedType> annotatedTypes = new ArrayList<AnnotatedType>();
        Class<?> extractorClass = extractor.getClass();
        DefaultValidatorConfiguration.determineValueExtractorDefinitions(annotatedTypes, extractorClass);
        if (annotatedTypes.size() != 1) {
            throw new IllegalStateException("Expected to find one annotation type! Got: " + annotatedTypes);
        }
        ValueExtractorRegistry valueExtractorRegistry1 = this.getValueExtractorRegistry();
        Argument argument = DefaultValidatorConfiguration.argumentOf((AnnotatedType)annotatedTypes.get(0));
        if (extractorClass.getAnnotations().length > 0) {
            argument = Argument.of((Class)argument.getType(), (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{argument.getAnnotationMetadata(), DefaultValidatorConfiguration.annotationMetadataOf(extractorClass)}), (Argument[])argument.getTypeParameters());
        }
        valueExtractorRegistry1.addValueExtractor(new ValueExtractorDefinition(argument, extractor));
        return this;
    }

    @NonNull
    private static Argument<?> argumentOf(@NonNull AnnotatedType type) {
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)type;
            return Argument.of(DefaultValidatorConfiguration.getClassFromType(type.getType()), (AnnotationMetadata)DefaultValidatorConfiguration.annotationMetadataOf(type), (Argument[])((Argument[])Arrays.stream(annotatedParameterizedType.getAnnotatedActualTypeArguments()).map(DefaultValidatorConfiguration::argumentOf).toArray(Argument[]::new)));
        }
        return Argument.of(DefaultValidatorConfiguration.getClassFromType(type.getType()), (AnnotationMetadata)DefaultValidatorConfiguration.annotationMetadataOf(type), (Argument[])new Argument[0]);
    }

    private static AnnotationMetadata annotationMetadataOf(AnnotatedElement annotatedElement) {
        Annotation[] annotations = annotatedElement.getAnnotations();
        if (annotations.length == 0) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
        for (Annotation annotation : annotations) {
            Method[] methods;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Method method : methods = annotationType.getMethods()) {
                if (!method.getDeclaringClass().equals(annotationType)) continue;
                try {
                    Object value = method.invoke((Object)annotation, new Object[0]);
                    if (value == null) continue;
                    values.put(method.getName(), value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            mutableAnnotationMetadata.addAnnotation(annotationType.getName(), values);
        }
        return mutableAnnotationMetadata;
    }

    public Validator getValidator() {
        return new DefaultValidator(this);
    }

    @Override
    public BeanIntrospector getBeanIntrospector() {
        return this.beanIntrospector;
    }

    public final void setBeanIntrospector(BeanIntrospector beanIntrospector) {
        this.beanIntrospector = beanIntrospector;
    }

    private static void determineValueExtractorDefinitions(List<AnnotatedType> valueExtractorDefinitions, Class<?> extractorImplementationType) {
        if (!ValueExtractor.class.isAssignableFrom(extractorImplementationType)) {
            return;
        }
        Class<?> superClass = extractorImplementationType.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            DefaultValidatorConfiguration.determineValueExtractorDefinitions(valueExtractorDefinitions, superClass);
        }
        for (Class<?> clazz : extractorImplementationType.getInterfaces()) {
            if (ValueExtractor.class.equals(clazz)) continue;
            DefaultValidatorConfiguration.determineValueExtractorDefinitions(valueExtractorDefinitions, clazz);
        }
        for (AnnotatedElement annotatedElement : extractorImplementationType.getAnnotatedInterfaces()) {
            if (!ValueExtractor.class.equals(DefaultValidatorConfiguration.getClassFromType(annotatedElement.getType()))) continue;
            valueExtractorDefinitions.add((AnnotatedType)annotatedElement);
        }
    }

    public static Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            return classType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return DefaultValidatorConfiguration.getClassFromType(parameterizedType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return DefaultValidatorConfiguration.getClassFromType(wildcardType.getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

