/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.common.clientenum;

public enum ConsistencyLevelEnum {
    STRONG("Strong", 0),
    BOUNDED("Bounded", 2),
    EVENTUALLY("Eventually", 3);

    private final String name;
    private final int code;
    private static final ConsistencyLevelEnum[] CONSISTENCY_LEVELS;

    private ConsistencyLevelEnum(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public static ConsistencyLevelEnum getNameByCode(int code) {
        if (code >= 0 && code < CONSISTENCY_LEVELS.length) {
            return CONSISTENCY_LEVELS[code];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    static {
        CONSISTENCY_LEVELS = new ConsistencyLevelEnum[ConsistencyLevelEnum.values().length];
    }
}

