/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class AlterCollectionParam {
    private final String collectionName;
    private final String databaseName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.properties.putAll(builder.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "AlterCollectionParam(collectionName=" + this.getCollectionName() + ", databaseName=" + this.getDatabaseName() + ", properties=" + this.getProperties() + ")";
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withTTL(@NonNull Integer ttlSeconds) {
            if (ttlSeconds == null) {
                throw new NullPointerException("ttlSeconds is marked non-null but is null");
            }
            if (ttlSeconds < 0) {
                throw new ParamException("The ttlSeconds value should be 0 or greater");
            }
            return this.withProperty("collection.ttl.seconds", Integer.toString(ttlSeconds));
        }

        public Builder withProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.properties.put(key, value);
            return this;
        }

        public AlterCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new AlterCollectionParam(this);
        }
    }
}

