/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Aggregator<T> {
    public AggregatorHandle<T> createHandle();

    default public T accumulateLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    default public T accumulateDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    public T merge(T var1, T var2);

    @Nullable
    public MetricData toMetricData(Resource var1, InstrumentationLibraryInfo var2, InstrumentDescriptor var3, Map<Labels, T> var4, long var5, long var7);
}

