/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.MinMaxSumCountAccumulation;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePoint;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPoint;
import io.opentelemetry.sdk.metrics.data.LongPoint;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class MetricDataUtils {
    private MetricDataUtils() {
    }

    static MetricData toLongSumMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, List<LongPoint> points, boolean isMonotonic) {
        return MetricData.createLongSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongSumData.create(isMonotonic, AggregationTemporality.CUMULATIVE, points));
    }

    static MetricData toDoubleSumMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, List<DoublePoint> points, boolean isMonotonic) {
        return MetricData.createDoubleSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), DoubleSumData.create(isMonotonic, AggregationTemporality.CUMULATIVE, points));
    }

    static List<LongPoint> toLongPointList(Map<Labels, Long> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<LongPoint> points = new ArrayList<LongPoint>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(LongPoint.create(startEpochNanos, epochNanos, labels, accumulation)));
        return points;
    }

    static List<DoublePoint> toDoublePointList(Map<Labels, Double> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(DoublePoint.create(startEpochNanos, epochNanos, labels, accumulation)));
        return points;
    }

    static List<DoubleSummaryPoint> toDoubleSummaryPointList(Map<Labels, MinMaxSumCountAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoubleSummaryPoint> points = new ArrayList<DoubleSummaryPoint>(accumulationMap.size());
        accumulationMap.forEach((labels, aggregator) -> points.add(aggregator.toPoint(startEpochNanos, epochNanos, (Labels)labels)));
        return points;
    }
}

