/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.Annotation;
import zipkin.Span;

public class ApplyTimestampAndDuration {
    public static Span apply(Span span) {
        if (span.timestamp != null && span.duration != null) {
            return span;
        }
        if (span.annotations.size() < 2) {
            return span;
        }
        Long first = span.annotations.get((int)0).timestamp;
        Long last = span.annotations.get((int)(span.annotations.size() - 1)).timestamp;
        for (Annotation annotation : span.annotations) {
            if (annotation.value.equals("cs")) {
                first = annotation.timestamp;
                continue;
            }
            if (!annotation.value.equals("cr")) continue;
            last = annotation.timestamp;
        }
        long ts = span.timestamp != null ? span.timestamp : first;
        Long dur = span.duration != null ? span.duration : (last.equals(first) ? null : Long.valueOf(last - first));
        return span.toBuilder().timestamp(ts).duration(dur).build();
    }

    private ApplyTimestampAndDuration() {
    }
}

