/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Util;

public final class MergeById {
    public static List<Span> apply(Iterable<Span> spans) {
        if (spans == null || !spans.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Span> result = new ArrayList<Span>();
        LinkedHashMap spanIdToSpans = new LinkedHashMap();
        for (Span span : spans) {
            if (!spanIdToSpans.containsKey(span.id)) {
                spanIdToSpans.put(span.id, new ArrayList());
            }
            ((List)spanIdToSpans.get(span.id)).add(span);
        }
        for (List spansToMerge : spanIdToSpans.values()) {
            if (spansToMerge.size() == 1) {
                result.add((Span)spansToMerge.get(0));
                continue;
            }
            Span.Builder builder = ((Span)spansToMerge.get(0)).toBuilder();
            int length = spansToMerge.size();
            for (int i = 1; i < length; ++i) {
                builder.merge((Span)spansToMerge.get(i));
            }
            result.add(builder.build());
        }
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, ApplyTimestampAndDuration.apply((Span)result.get(i)));
        }
        return Util.sortedList(result);
    }

    private MergeById() {
    }
}

