/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import zipkin2.internal.Buffer;

public final class JsonEscaper {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String U2028 = "\\u2028";
    private static final String U2029 = "\\u2029";

    public static String jsonEscape(String v) {
        String escaped;
        if (v.isEmpty()) {
            return v;
        }
        int afterReplacement = 0;
        int length = v.length();
        StringBuilder builder = null;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = v.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = U2028;
            } else {
                if (c != '\u2029') continue;
                replacement = U2029;
            }
            if (afterReplacement < i) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(v, afterReplacement, i);
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(replacement);
            afterReplacement = i + 1;
        }
        if (builder == null) {
            escaped = v;
        } else {
            if (afterReplacement < length) {
                builder.append(v, afterReplacement, length);
            }
            escaped = builder.toString();
        }
        return escaped;
    }

    public static boolean needsJsonEscaping(byte[] v) {
        for (int i = 0; i < v.length; ++i) {
            int current = v[i] & 0xFF;
            if (i >= 2 && (current == 168 || current == 169) && (v[i - 1] & 0xFF) == 128 && (v[i - 2] & 0xFF) == 226) {
                return true;
            }
            if (current >= 128 || REPLACEMENT_CHARS[current] == null) continue;
            return true;
        }
        return false;
    }

    public static int jsonEscapedSizeInBytes(String v) {
        boolean ascii = true;
        int escapingOverhead = 0;
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            char c = v.charAt(i);
            if (c == '\u2028' || c == '\u2029') {
                escapingOverhead += 5;
                continue;
            }
            if (c >= '\u0080') {
                ascii = false;
                continue;
            }
            String maybeReplacement = REPLACEMENT_CHARS[c];
            if (maybeReplacement == null) continue;
            escapingOverhead += maybeReplacement.length() - 1;
        }
        if (ascii) {
            return v.length() + escapingOverhead;
        }
        return Buffer.utf8SizeInBytes(v) + escapingOverhead;
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonEscaper.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonEscaper.REPLACEMENT_CHARS[34] = "\\\"";
        JsonEscaper.REPLACEMENT_CHARS[92] = "\\\\";
        JsonEscaper.REPLACEMENT_CHARS[9] = "\\t";
        JsonEscaper.REPLACEMENT_CHARS[8] = "\\b";
        JsonEscaper.REPLACEMENT_CHARS[10] = "\\n";
        JsonEscaper.REPLACEMENT_CHARS[13] = "\\r";
        JsonEscaper.REPLACEMENT_CHARS[12] = "\\f";
    }
}

