/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CorsHandler
implements HttpHandler,
HandlerWrapper {
    private static Logger logger = Logger.getLogger(CorsHandler.class.getName());
    static final HttpString OPTIONS = HttpString.tryFromString((String)"OPTIONS");
    static final HttpString ORIGIN = HttpString.tryFromString((String)"origin");
    static final HttpString VARY = HttpString.tryFromString((String)"vary");
    static final HttpString ACCESS_CONTROL_ALLOW_METHODS = HttpString.tryFromString((String)"access-control-allow-methods");
    static final HttpString ACCESS_CONTROL_ALLOW_HEADERS = HttpString.tryFromString((String)"access-control-allow-headers");
    static final HttpString ACCESS_CONTROL_ALLOW_ORIGIN = HttpString.tryFromString((String)"access-control-allow-origin");
    static final HttpString ACCESS_CONTROL_REQUEST_METHOD = HttpString.tryFromString((String)"access-control-request-method");
    static final HttpString ACCESS_CONTROL_REQUEST_HEADERS = HttpString.tryFromString((String)"access-control-request-headers");
    final List<String> allowedOrigins;
    final List<String> allowedHeaders;
    final boolean wildcardOrigin;
    HttpHandler next;

    CorsHandler(String allowedOrigins) {
        this.allowedOrigins = Arrays.asList(allowedOrigins.split(","));
        this.allowedHeaders = Arrays.asList("accept", "content-type", "content-encoding", "origin");
        this.wildcardOrigin = this.allowedOrigins.contains("*");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (CorsHandler.isPreflightRequest(exchange)) {
            this.handlePreflight(exchange);
            exchange.getResponseSender().close();
            return;
        }
        if (!this.validateOrigin(exchange)) {
            exchange.setStatusCode(403).getResponseSender().send("CORS error\n");
            return;
        }
        this.next.handleRequest(exchange);
    }

    void handlePreflight(HttpServerExchange exchange) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String origin = requestHeaders.getFirst(ORIGIN);
        String method = requestHeaders.getFirst(ACCESS_CONTROL_REQUEST_METHOD);
        String requestedHeaders = requestHeaders.getFirst(ACCESS_CONTROL_REQUEST_HEADERS);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        responseHeaders.put(VARY, "origin,access-control-request-method,access-control-request-headers");
        if (("POST".equals(method) || "GET".equals(method)) && this.requestedHeadersAllowed(requestedHeaders) && this.setOrigin(origin, responseHeaders)) {
            responseHeaders.put(ACCESS_CONTROL_ALLOW_METHODS, method);
            if (requestedHeaders != null) {
                responseHeaders.put(ACCESS_CONTROL_ALLOW_HEADERS, requestedHeaders);
            }
        }
    }

    boolean requestedHeadersAllowed(String requestedHeaders) {
        if (requestedHeaders == null) {
            return true;
        }
        StringBuilder next = new StringBuilder();
        int length = requestedHeaders.length();
        for (int i = 0; i < length; ++i) {
            char c = requestedHeaders.charAt(i);
            if (c == ' ') continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (c != ',') {
                next.append(c);
            }
            if (c != ',' && i + 1 != length) continue;
            String toTest = next.toString();
            if (!this.allowedHeaders.contains(toTest)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(toTest + " is not an allowed header: " + this.allowedHeaders);
                }
                return false;
            }
            next.setLength(0);
        }
        return true;
    }

    boolean validateOrigin(HttpServerExchange exchange) {
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        responseHeaders.put(VARY, "origin");
        String origin = exchange.getRequestHeaders().getFirst(ORIGIN);
        if (origin == null) {
            return true;
        }
        return this.setOrigin(origin, responseHeaders);
    }

    private static boolean isPreflightRequest(HttpServerExchange exchange) {
        HeaderMap headers = exchange.getRequestHeaders();
        return exchange.getRequestMethod().equals(OPTIONS) && headers.contains(ORIGIN) && headers.contains(ACCESS_CONTROL_REQUEST_METHOD);
    }

    private boolean setOrigin(String origin, HeaderMap responseHeaders) {
        if ("null".equals(origin)) {
            responseHeaders.put(ACCESS_CONTROL_ALLOW_ORIGIN, "null");
            return true;
        }
        if (this.wildcardOrigin) {
            responseHeaders.put(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
            return true;
        }
        if (this.allowedOrigins.contains(origin)) {
            responseHeaders.put(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            return true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(origin + " is not an allowed origin: " + this.allowedOrigins);
        }
        return false;
    }

    public HttpHandler wrap(HttpHandler handler) {
        this.next = handler;
        return this;
    }
}

