/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import com.github.kristofa.brave.Brave;
import io.undertow.server.HandlerWrapper;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.V2StorageComponent;
import zipkin.server.ActuateCollectorMetrics;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.CorsHandler;
import zipkin.server.ZipkinHealthIndicator;
import zipkin.server.ZipkinHttpCollector;
import zipkin.server.brave.TracedStorageComponent;
import zipkin2.storage.InMemoryStorage;
import zipkin2.storage.StorageComponent;

@Configuration
public class ZipkinServerConfiguration {
    @Autowired(required=false)
    UndertowDeploymentInfoCustomizer httpRequestDurationCustomizer;
    @Autowired(required=false)
    ZipkinHttpCollector httpCollector;

    @Bean
    ZipkinHealthIndicator zipkinHealthIndicator(HealthAggregator healthAggregator) {
        return new ZipkinHealthIndicator(healthAggregator);
    }

    @Bean
    public UndertowEmbeddedServletContainerFactory embeddedServletContainerFactory(@Value(value="${zipkin.query.allowed-origins:*}") String allowedOrigins) {
        UndertowEmbeddedServletContainerFactory factory = new UndertowEmbeddedServletContainerFactory();
        CorsHandler cors = new CorsHandler(allowedOrigins);
        if (this.httpCollector != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)this.httpCollector)});
        }
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)cors)});
        if (this.httpRequestDurationCustomizer != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this.httpRequestDurationCustomizer});
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorSampler.class})
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorMetrics.class})
    CollectorMetrics metrics(Optional<CounterBuffers> counterBuffers, Optional<GaugeBuffers> gaugeBuffers) {
        return new ActuateCollectorMetrics(counterBuffers.orElse(new CounterBuffers()), gaugeBuffers.orElse(new GaugeBuffers()));
    }

    static final class StorageTypeMemAbsentOrEmpty
    implements Condition {
        StorageTypeMemAbsentOrEmpty() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String storageType = condition.getEnvironment().getProperty("zipkin.storage.type");
            if (storageType == null) {
                return true;
            }
            if ((storageType = storageType.trim()).isEmpty()) {
                return true;
            }
            return storageType.equals("mem");
        }
    }

    @Configuration
    @Conditional(value={StorageTypeMemAbsentOrEmpty.class})
    @ConditionalOnMissingBean(value={zipkin.storage.StorageComponent.class})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Bean
        zipkin.storage.StorageComponent storage(@Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.mem.max-spans:500000}") int maxSpans) {
            return V2StorageComponent.create((StorageComponent)InMemoryStorage.newBuilder().strictTraceId(strictTraceId).maxSpanCount(maxSpans).build());
        }

        @Bean
        InMemoryStorage v2Storage(V2StorageComponent component) {
            return (InMemoryStorage)component.delegate();
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class BraveTracedStorageComponentEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Brave brave;

        BraveTracedStorageComponentEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof zipkin.storage.StorageComponent && this.brave != null && !(bean instanceof V2StorageComponent)) {
                return new TracedStorageComponent(this.brave, (zipkin.storage.StorageComponent)bean);
            }
            return bean;
        }
    }
}

