/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import brave.Tracer;
import brave.sampler.BoundarySampler;
import brave.sampler.Sampler;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.InheritableServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.TracerAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import zipkin.Codec;
import zipkin.Component;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.reporter.AsyncReporter;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Reporter;
import zipkin.reporter.ReporterMetrics;
import zipkin.reporter.Sender;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.brave.ApiTracerConfiguration;
import zipkin.storage.StorageComponent;

@Configuration
@ConditionalOnSelfTracing
@Import(value={ApiTracerConfiguration.class})
public class BraveConfiguration {
    @Bean
    @Scope
    Endpoint local(@Value(value="${server.port:9411}") int port) {
        Endpoint.Builder builder = Endpoint.builder().serviceName("zipkin-server").port(port == -1 ? 0 : port);
        try {
            InetAddress address = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(i -> Collections.list(i.getInetAddresses()).stream()).filter(ip -> ip.isSiteLocalAddress()).findAny().get();
            builder.parseIp(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.build();
    }

    @Bean
    Reporter<Span> reporter(@Lazy StorageComponent storage, @Value(value="${zipkin.self-tracing.flush-interval:1}") int flushInterval, CollectorMetrics metrics) {
        return AsyncReporter.builder((Sender)new LocalSender(storage)).messageTimeout((long)flushInterval, TimeUnit.SECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(metrics.forTransport("local"))).build();
    }

    @Bean
    ServerClientAndLocalSpanState braveState(@Qualifier(value="local") Endpoint local) {
        com.twitter.zipkin.gen.Endpoint braveEndpoint = com.twitter.zipkin.gen.Endpoint.builder().ipv4(local.ipv4).ipv6(local.ipv6).port(local.port).serviceName(local.serviceName).build();
        return new InheritableServerClientAndLocalSpanState(braveEndpoint);
    }

    @Bean
    Tracer braveTracer(Reporter<Span> reporter, @Qualifier(value="local") Endpoint local, @Value(value="${zipkin.self-tracing.sample-rate:1.0}") float rate) {
        return Tracer.newBuilder().localEndpoint(local).sampler((double)rate < 0.01 ? BoundarySampler.create((float)rate) : Sampler.create((float)rate)).reporter(reporter).build();
    }

    @Bean
    Brave brave(Tracer braveTracer, ServerClientAndLocalSpanState braveState) {
        return TracerAdapter.newBrave((Tracer)braveTracer, (ServerClientAndLocalSpanState)braveState);
    }

    static final class ReporterMetricsAdapter
    implements ReporterMetrics {
        final CollectorMetrics delegate;

        ReporterMetricsAdapter(CollectorMetrics delegate) {
            this.delegate = delegate;
        }

        public void incrementMessages() {
            this.delegate.incrementMessages();
        }

        public void incrementMessagesDropped(Throwable throwable) {
            this.delegate.incrementMessagesDropped();
        }

        public void incrementSpans(int i) {
            this.delegate.incrementSpans(i);
        }

        public void incrementSpanBytes(int i) {
            this.delegate.incrementBytes(i);
        }

        public void incrementMessageBytes(int i) {
        }

        public void incrementSpansDropped(int i) {
            this.delegate.incrementMessagesDropped();
        }

        public void updateQueuedSpans(int i) {
        }

        public void updateQueuedBytes(int i) {
        }
    }

    static final class CallbackAdapter
    implements zipkin.storage.Callback<Void> {
        final Callback delegate;

        CallbackAdapter(Callback delegate) {
            this.delegate = delegate;
        }

        public void onSuccess(@Nullable Void aVoid) {
            this.delegate.onComplete();
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }
    }

    static final class LocalSender
    implements Sender {
        private final StorageComponent delegate;

        LocalSender(StorageComponent delegate) {
            this.delegate = delegate;
        }

        public Encoding encoding() {
            return Encoding.THRIFT;
        }

        public int messageMaxBytes() {
            return 0x500000;
        }

        public int messageSizeInBytes(List<byte[]> list) {
            return Encoding.THRIFT.listSizeInBytes(list);
        }

        public void sendSpans(List<byte[]> encodedSpans, Callback callback) {
            try {
                ArrayList<Span> spans = new ArrayList<Span>(encodedSpans.size());
                for (byte[] encodedSpan : encodedSpans) {
                    spans.add(Codec.THRIFT.readSpan(encodedSpan));
                }
                this.delegate.asyncSpanConsumer().accept(spans, (zipkin.storage.Callback)new CallbackAdapter(callback));
            }
            catch (Throwable t) {
                Util.propagateIfFatal((Throwable)t);
                callback.onError(t);
            }
        }

        public Component.CheckResult check() {
            return Component.CheckResult.OK;
        }

        public void close() throws IOException {
        }
    }
}

